/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.parser.defaults;

import java.util.List;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.parser.OrderBySqlParser;

public class DefaultOrderBySqlParser
implements OrderBySqlParser {
    public static List<OrderByElement> extraOrderBy(Select select) {
        if (select != null) {
            if (select instanceof PlainSelect || select instanceof SetOperationList) {
                List orderByElements = select.getOrderByElements();
                select.setOrderByElements(null);
                return orderByElements;
            }
            if (select instanceof ParenthesedSelect) {
                DefaultOrderBySqlParser.extraOrderBy(((ParenthesedSelect)select).getSelect());
            }
        }
        return null;
    }

    @Override
    public String converToOrderBySql(String sql, String orderBy) {
        try {
            Statement stmt = Builder.parse(sql);
            Select select = (Select)stmt;
            List<OrderByElement> orderByElements = DefaultOrderBySqlParser.extraOrderBy(select);
            String defaultOrderBy = PlainSelect.orderByToString(orderByElements);
            if (defaultOrderBy.indexOf(63) != -1) {
                throw new PageException("The order by in the original SQL[" + sql + "] contains parameters, so it cannot be modified using the OrderBy plugin!");
            }
            sql = select.toString();
        }
        catch (Throwable e) {
            Logger.warn((String)("Failed to handle sorting: " + String.valueOf(e) + ", downgraded to a direct splice of the order by parameter"), (Object[])new Object[0]);
        }
        return sql + " order by " + orderBy;
    }
}

