/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.parser.defaults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.WithItem;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.parser.SqlServerSqlParser;

public class DefaultSqlServerSqlParser
implements SqlServerSqlParser {
    public static final String START_ROW = String.valueOf(Long.MIN_VALUE);
    public static final String PAGE_SIZE = String.valueOf(Long.MAX_VALUE);
    protected static final String WRAP_TABLE = "WRAP_OUTER_TABLE";
    protected static final String PAGE_TABLE_NAME = "PAGE_TABLE_ALIAS";
    public static final Alias PAGE_TABLE_ALIAS = new Alias("PAGE_TABLE_ALIAS");
    protected static final String PAGE_ROW_NUMBER = "PAGE_ROW_NUMBER";
    protected static final Column PAGE_ROW_NUMBER_COLUMN = new Column("PAGE_ROW_NUMBER");
    protected static final Top TOP100_PERCENT = new Top();
    protected static final String PAGE_COLUMN_ALIAS_PREFIX = "ROW_ALIAS_";

    public String convertToPageSql(String sql) {
        return this.convertToPageSql(sql, null, null);
    }

    @Override
    public String convertToPageSql(String sql, Integer offset, Integer limit) {
        Statement stmt;
        try {
            stmt = Builder.parse(sql);
        }
        catch (Throwable e) {
            throw new PageException("The SQL statement cannot be converted to a pagination query!", e);
        }
        if (!(stmt instanceof Select)) {
            throw new PageException("the pagination statement must be a select query!");
        }
        Select pageSelect = this.getPageSelect((Select)stmt);
        String pageSql = pageSelect.toString();
        if (offset != null) {
            pageSql = pageSql.replace(START_ROW, String.valueOf(offset));
        }
        if (limit != null) {
            pageSql = pageSql.replace(PAGE_SIZE, String.valueOf(limit));
        }
        return pageSql;
    }

    protected Select getPageSelect(Select select) {
        if (select instanceof SetOperationList) {
            select = this.wrapSetOperationList((SetOperationList)select);
        }
        if (((PlainSelect)select).getTop() != null) {
            throw new PageException("The pagination statement already contains the top, and can no longer be used to query the pagination plugin!");
        }
        List<SelectItem<?>> selectItems = this.getSelectItems((PlainSelect)select);
        ArrayList autoItems = new ArrayList();
        SelectItem<?> orderByColumn = this.addRowNumber((PlainSelect)select, autoItems);
        ((PlainSelect)select).addSelectItems(autoItems.toArray(new SelectItem[0]));
        this.processSelectBody(select, 0);
        PlainSelect innerSelectBody = new PlainSelect();
        innerSelectBody.addSelectItems(new SelectItem[]{orderByColumn});
        innerSelectBody.addSelectItems(selectItems.toArray(new SelectItem[0]));
        ParenthesedSelect fromInnerItem = new ParenthesedSelect();
        fromInnerItem.setSelect(select);
        fromInnerItem.setAlias(PAGE_TABLE_ALIAS);
        innerSelectBody.setFromItem((FromItem)fromInnerItem);
        PlainSelect newSelect = new PlainSelect();
        Top top = new Top();
        top.setExpression((Expression)new LongValue(Long.MAX_VALUE));
        newSelect.setTop(top);
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>();
        OrderByElement orderByElement = new OrderByElement();
        orderByElement.setExpression((Expression)PAGE_ROW_NUMBER_COLUMN);
        orderByElements.add(orderByElement);
        newSelect.setOrderByElements(orderByElements);
        GreaterThan greaterThan = new GreaterThan();
        greaterThan.setLeftExpression((Expression)PAGE_ROW_NUMBER_COLUMN);
        greaterThan.setRightExpression((Expression)new LongValue(Long.MIN_VALUE));
        newSelect.setWhere((Expression)greaterThan);
        newSelect.setSelectItems(selectItems);
        ParenthesedSelect fromItem = new ParenthesedSelect();
        fromItem.setSelect((Select)innerSelectBody);
        fromItem.setAlias(PAGE_TABLE_ALIAS);
        newSelect.setFromItem((FromItem)fromItem);
        if (this.isNotEmptyList(select.getWithItemsList())) {
            newSelect.setWithItemsList(select.getWithItemsList());
            select.setWithItemsList(null);
        }
        return newSelect;
    }

    protected Select wrapSetOperationList(SetOperationList setOperationList) {
        Select setSelectBody = (Select)setOperationList.getSelects().get(setOperationList.getSelects().size() - 1);
        if (!(setSelectBody instanceof PlainSelect)) {
            throw new PageException("Unable to process the SQL, you can submit issues in GitHub for help.!");
        }
        PlainSelect plainSelect = (PlainSelect)setSelectBody;
        PlainSelect selectBody = new PlainSelect();
        List<SelectItem<?>> selectItems = this.getSelectItems(plainSelect);
        selectBody.setSelectItems(selectItems);
        ParenthesedSelect fromItem = new ParenthesedSelect();
        fromItem.setSelect((Select)setOperationList);
        fromItem.setAlias(new Alias(WRAP_TABLE));
        selectBody.setFromItem((FromItem)fromItem);
        if (this.isNotEmptyList(setOperationList.getOrderByElements())) {
            selectBody.setOrderByElements(setOperationList.getOrderByElements());
            setOperationList.setOrderByElements(null);
        }
        return selectBody;
    }

    protected List<SelectItem<?>> getSelectItems(PlainSelect plainSelect) {
        ArrayList selectItems = new ArrayList();
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            Column column;
            if (selectItem.getExpression() instanceof AllTableColumns) {
                selectItems.add(new SelectItem((Expression)new AllColumns()));
                continue;
            }
            if (selectItem.getAlias() != null) {
                column = new Column(selectItem.getAlias().getName());
                SelectItem expressionItem = new SelectItem((Expression)column);
                selectItems.add(expressionItem);
                continue;
            }
            if (selectItem.getExpression() instanceof Column) {
                column = (Column)selectItem.getExpression();
                SelectItem item = null;
                if (column.getTable() != null) {
                    Column newColumn = new Column(column.getColumnName());
                    item = new SelectItem((Expression)newColumn);
                    selectItems.add(item);
                    continue;
                }
                selectItems.add(selectItem);
                continue;
            }
            selectItems.add(selectItem);
        }
        for (SelectItem selectItem : selectItems) {
            if (!(selectItem.getExpression() instanceof AllColumns)) continue;
            return Collections.singletonList(selectItem);
        }
        return selectItems;
    }

    protected SelectItem<?> addRowNumber(PlainSelect plainSelect, List<SelectItem<?>> autoItems) {
        StringBuilder orderByBuilder = new StringBuilder();
        orderByBuilder.append("ROW_NUMBER() OVER (");
        if (this.isNotEmptyList(plainSelect.getOrderByElements())) {
            orderByBuilder.append(PlainSelect.orderByToString(this.getOrderByElements(plainSelect, autoItems)).substring(1));
            plainSelect.setOrderByElements(null);
        } else {
            orderByBuilder.append("ORDER BY RAND()");
        }
        orderByBuilder.append(") ");
        orderByBuilder.append(PAGE_ROW_NUMBER);
        return new SelectItem((Expression)new Column(orderByBuilder.toString()));
    }

    protected void processSelectBody(Select select, int level) {
        if (select != null) {
            if (select instanceof PlainSelect) {
                this.processPlainSelect((PlainSelect)select, level + 1);
            } else if (select instanceof WithItem) {
                WithItem withItem = (WithItem)select;
                if (withItem.getSelect() != null) {
                    this.processSelectBody(withItem.getSelect(), level + 1);
                }
            } else {
                SetOperationList operationList = (SetOperationList)select;
                if (operationList.getSelects() != null && !operationList.getSelects().isEmpty()) {
                    List plainSelects = operationList.getSelects();
                    for (Select plainSelect : plainSelects) {
                        this.processSelectBody(plainSelect, level + 1);
                    }
                }
            }
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect, int level) {
        if (level > 1 && this.isNotEmptyList(plainSelect.getOrderByElements()) && plainSelect.getTop() == null) {
            plainSelect.setTop(TOP100_PERCENT);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem(), level + 1);
        }
        if (plainSelect.getJoins() != null && !plainSelect.getJoins().isEmpty()) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem(), level + 1);
            }
        }
    }

    protected void processFromItem(FromItem fromItem, int level) {
        if (fromItem instanceof LateralSubSelect) {
            this.processSelectBody(((LateralSubSelect)fromItem).getSelect(), level + 1);
        } else if (fromItem instanceof ParenthesedSelect) {
            this.processSelectBody(((ParenthesedSelect)fromItem).getSelect(), level + 1);
        } else if (fromItem instanceof Select) {
            this.processSelectBody((Select)fromItem, level + 1);
        } else if (fromItem instanceof ParenthesedFromItem) {
            this.processFromItem(((ParenthesedFromItem)fromItem).getFromItem(), level + 1);
        }
    }

    public boolean isNotEmptyList(List<?> list) {
        return list != null && !list.isEmpty();
    }

    protected OrderByElement cloneOrderByElement(OrderByElement orig, String alias) {
        return this.cloneOrderByElement(orig, (Expression)new Column(alias));
    }

    protected OrderByElement cloneOrderByElement(OrderByElement orig, Expression expression) {
        OrderByElement element = new OrderByElement();
        element.setAsc(orig.isAsc());
        element.setAscDescPresent(orig.isAscDescPresent());
        element.setNullOrdering(orig.getNullOrdering());
        element.setExpression(expression);
        return element;
    }

    protected List<OrderByElement> getOrderByElements(PlainSelect plainSelect, List<SelectItem<?>> autoItems) {
        Alias alias;
        List orderByElements = plainSelect.getOrderByElements();
        ListIterator<OrderByElement> iterator = orderByElements.listIterator();
        HashMap<String, SelectItem> selectMap = new HashMap<String, SelectItem>();
        HashSet<String> aliases = new HashSet<String>();
        boolean allColumns = false;
        HashSet<String> allColumnsTables = new HashSet<String>();
        for (SelectItem item : plainSelect.getSelectItems()) {
            Expression expression = item.getExpression();
            if (expression instanceof AllTableColumns) {
                allColumnsTables.add(((AllTableColumns)expression).getTable().getName());
                continue;
            }
            if (expression instanceof AllColumns) {
                allColumns = true;
                continue;
            }
            selectMap.put(expression.toString(), item);
            alias = item.getAlias();
            if (alias == null) continue;
            aliases.add(alias.getName());
        }
        int aliasNo = 1;
        while (iterator.hasNext()) {
            OrderByElement orderByElement = (OrderByElement)iterator.next();
            Expression expression = orderByElement.getExpression();
            SelectItem selectExpressionItem = (SelectItem)selectMap.get(expression.toString());
            if (selectExpressionItem != null) {
                alias = selectExpressionItem.getAlias();
                if (alias != null) {
                    iterator.set(this.cloneOrderByElement(orderByElement, alias.getName()));
                    continue;
                }
                if (expression instanceof Column) {
                    ((Column)expression).setTable(null);
                    continue;
                }
                throw new PageException("The column \"" + String.valueOf(expression) + "\" needs to define an alias");
            }
            if (expression instanceof Column) {
                Table table = ((Column)expression).getTable();
                if (table == null) {
                    if (allColumns || allColumnsTables.size() == 1 && plainSelect.getJoins() == null || aliases.contains(((Column)expression).getColumnName())) {
                        continue;
                    }
                } else {
                    String tableName = table.getName();
                    if (allColumns || allColumnsTables.contains(tableName)) {
                        ((Column)expression).setTable(null);
                        continue;
                    }
                }
            }
            String aliasName = PAGE_COLUMN_ALIAS_PREFIX + aliasNo++;
            SelectItem item = new SelectItem(expression);
            item.setAlias(new Alias(aliasName));
            autoItems.add(item);
            iterator.set(this.cloneOrderByElement(orderByElement, aliasName));
        }
        return orderByElements;
    }

    static {
        TOP100_PERCENT.setExpression((Expression)new LongValue(100L));
        TOP100_PERCENT.setPercentage(true);
    }
}

