/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.plugin;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.miaixz.bus.core.data.ID;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.pager.plugin.SqlParserHandler;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class NatureSqlHandler
extends SqlParserHandler
implements Interceptor {
    private static void getSql(Configuration configuration, BoundSql boundSql, String sqlId, long time) {
        Logger.debug((String)(sqlId + " :  ==> " + time + " ms"), (Object[])new Object[0]);
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String id = ID.objectId();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ").replaceAll("\\?", id);
        if (!CollKit.isEmpty((Collection)parameterMappings) && null != parameterObject) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst(id, Matcher.quoteReplacement(NatureSqlHandler.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object object;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        object = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst(id, Matcher.quoteReplacement(NatureSqlHandler.getParameterValue(object)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        object = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst(id, Matcher.quoteReplacement(NatureSqlHandler.getParameterValue(object)));
                        continue;
                    }
                    sql = sql.replaceFirst(id, "Missing");
                }
            }
        }
        Logger.debug((String)sql, (Object[])new Object[0]);
    }

    private static String getParameterValue(Object object) {
        Object value;
        if (object instanceof String) {
            value = "'" + String.valueOf(object) + "'";
        } else if (object instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = null != object ? object.toString() : "";
        }
        return value;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        long start = System.currentTimeMillis();
        Object returnValue = invocation.proceed();
        long end = System.currentTimeMillis();
        try {
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = null;
            if (invocation.getArgs().length > 1) {
                parameter = invocation.getArgs()[1];
            }
            NatureSqlHandler.getSql(ms.getConfiguration(), ms.getBoundSql(parameter), ms.getId(), end - start);
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        return returnValue;
    }

    public Object plugin(Object object) {
        if (object instanceof Executor) {
            return Plugin.wrap((Object)object, (Interceptor)this);
        }
        return object;
    }
}

