/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.plugin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.SimpleExecutor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.Dialect;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.builtin.CountExecutor;
import org.miaixz.bus.pager.builtin.CountMappedStatement;
import org.miaixz.bus.pager.builtin.CountMsId;
import org.miaixz.bus.pager.builtin.PageMethod;
import org.miaixz.bus.pager.cache.Cache;
import org.miaixz.bus.pager.cache.CacheFactory;
import org.miaixz.bus.pager.plugin.BoundSqlHandler;
import org.miaixz.bus.pager.plugin.SqlParserHandler;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class PageSqlHandler
extends SqlParserHandler
implements Interceptor {
    private static boolean debug = false;
    protected Cache<String, MappedStatement> msCountMap = null;
    protected CountMsId countMsId = CountMsId.DEFAULT;
    private volatile Dialect dialect;
    private String countSuffix = "_COUNT";
    private String default_dialect_class = "org.miaixz.bus.pager.PageContext";

    public static boolean isDebug() {
        return debug;
    }

    protected void debugStackTraceLog() {
        if (PageSqlHandler.isDebug()) {
            Page page = PageMethod.getLocalPage();
            Logger.debug((String)page.getStackTrace(), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        try {
            List resultList;
            CacheKey cacheKey;
            BoundSql boundSql;
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            ResultHandler resultHandler = (ResultHandler)args[3];
            Executor executor = (Executor)invocation.getTarget();
            if (args.length == 4) {
                boundSql = ms.getBoundSql(parameter);
                cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
            } else {
                cacheKey = (CacheKey)args[4];
                boundSql = (BoundSql)args[5];
            }
            this.checkDialectExists();
            if (this.dialect instanceof BoundSqlHandler.Chain) {
                boundSql = ((BoundSqlHandler.Chain)((Object)this.dialect)).doBoundSql(BoundSqlHandler.Type.ORIGINAL, boundSql, cacheKey);
            }
            if (!this.dialect.skip(ms, parameter, rowBounds)) {
                Long count;
                this.debugStackTraceLog();
                Future<Long> countFuture = null;
                if (this.dialect.beforeCount(ms, parameter, rowBounds)) {
                    if (this.dialect.isAsyncCount()) {
                        countFuture = this.asyncCount(ms, boundSql, parameter, rowBounds);
                    } else {
                        count = this.count(executor, ms, parameter, rowBounds, null, boundSql);
                        if (!this.dialect.afterCount(count, parameter, rowBounds)) {
                            Object object = this.dialect.afterPage(new ArrayList(), parameter, rowBounds);
                            return object;
                        }
                    }
                }
                resultList = CountExecutor.pageQuery(this.dialect, executor, ms, parameter, rowBounds, resultHandler, boundSql, cacheKey);
                if (countFuture != null) {
                    count = countFuture.get();
                    this.dialect.afterCount(count, parameter, rowBounds);
                }
            } else {
                resultList = executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
            }
            Object object = this.dialect.afterPage(resultList, parameter, rowBounds);
            return object;
        }
        finally {
            if (this.dialect != null) {
                this.dialect.afterAll();
            }
        }
    }

    private Future<Long> asyncCount(MappedStatement ms, BoundSql boundSql, Object parameter, RowBounds rowBounds) {
        Configuration configuration = ms.getConfiguration();
        BoundSql countBoundSql = new BoundSql(configuration, boundSql.getSql(), new ArrayList(boundSql.getParameterMappings()), parameter);
        Environment environment = configuration.getEnvironment();
        Object transactionFactory = null;
        transactionFactory = environment == null || environment.getTransactionFactory() == null ? new ManagedTransactionFactory() : environment.getTransactionFactory();
        Transaction tx = transactionFactory.newTransaction(environment.getDataSource(), null, false);
        CachingExecutor countExecutor = new CachingExecutor((Executor)new SimpleExecutor(configuration, tx));
        return this.dialect.asyncCountTask(() -> this.lambda$asyncCount$0((Executor)countExecutor, ms, parameter, rowBounds, countBoundSql, tx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDialectExists() {
        if (this.dialect == null) {
            String string = this.default_dialect_class;
            synchronized (string) {
                if (this.dialect == null) {
                    this.setProperties(new Properties());
                }
            }
        }
    }

    private Long count(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Long count;
        String countMsId = this.countMsId.genCountMsId(ms, parameter, boundSql, this.countSuffix);
        MappedStatement countMs = CountExecutor.getExistedMappedStatement(ms.getConfiguration(), countMsId);
        if (countMs != null) {
            count = CountExecutor.executeManualCount(executor, countMs, parameter, boundSql, resultHandler);
        } else {
            if (this.msCountMap != null) {
                countMs = this.msCountMap.get(countMsId);
            }
            if (countMs == null) {
                countMs = CountMappedStatement.newCountMappedStatement(ms, countMsId);
                if (this.msCountMap != null) {
                    this.msCountMap.put(countMsId, countMs);
                }
            }
            count = CountExecutor.executeAutoCount(this.dialect, executor, countMs, parameter, boundSql, rowBounds, resultHandler);
        }
        return count;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.msCountMap = CacheFactory.createCache(properties.getProperty("msCountCache"), "ms", properties);
        String dialectClass = properties.getProperty("dialect");
        if (StringKit.isEmpty((CharSequence)dialectClass)) {
            dialectClass = this.default_dialect_class;
        }
        Dialect tempDialect = (Dialect)Builder.newInstance(dialectClass, properties);
        tempDialect.setProperties(properties);
        String countSuffix = properties.getProperty("countSuffix");
        if (StringKit.isNotEmpty((CharSequence)countSuffix)) {
            this.countSuffix = countSuffix;
        }
        debug = Boolean.parseBoolean(properties.getProperty("debug"));
        String countMsIdGenClass = properties.getProperty("countMsId");
        if (StringKit.isNotEmpty((CharSequence)countMsIdGenClass)) {
            this.countMsId = (CountMsId)Builder.newInstance(countMsIdGenClass, properties);
        }
        this.dialect = tempDialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Long lambda$asyncCount$0(Executor countExecutor, MappedStatement ms, Object parameter, RowBounds rowBounds, BoundSql countBoundSql, Transaction tx) throws Exception {
        try {
            Long l = this.count(countExecutor, ms, parameter, rowBounds, null, countBoundSql);
            return l;
        }
        finally {
            tx.close();
        }
    }
}

