/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.plugin;

import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.reflection.MetaObject;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.handler.AbstractSqlHandler;

public abstract class SqlParserHandler
extends AbstractSqlHandler {
    public String parser(MetaObject metaObject, String sql) {
        if (this.allowProcess(metaObject)) {
            try {
                Logger.debug((String)("Original SQL: " + sql), (Object[])new Object[0]);
                StringBuilder sqlStringBuilder = new StringBuilder();
                Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
                int i = 0;
                for (Statement statement : statements.getStatements()) {
                    if (null == statement) continue;
                    if (i++ > 0) {
                        sqlStringBuilder.append(';');
                    }
                    sqlStringBuilder.append(this.processParser(statement));
                }
                if (sqlStringBuilder.length() > 0) {
                    return sqlStringBuilder.toString();
                }
            }
            catch (JSQLParserException e) {
                throw new InternalException("Failed to process, please exclude the tableName or statementId.\n Error SQL: %s", new Object[]{e, sql});
            }
        }
        return null;
    }

    public String processParser(Statement statement) {
        if (statement instanceof Insert) {
            this.processInsert((Insert)statement);
        } else if (statement instanceof Select) {
            this.processSelectBody(((Select)statement).getSelectBody());
        } else if (statement instanceof Update) {
            this.processUpdate((Update)statement);
        } else if (statement instanceof Delete) {
            this.processDelete((Delete)statement);
        }
        if (Logger.isDebug()) {
            Logger.debug((String)("Parser SQL: " + statement.toString()), (Object[])new Object[0]);
        }
        return statement.toString();
    }

    public void processSelectBody(Select select) {
        if (select != null) {
            if (select instanceof WithItem) {
                WithItem withItem = (WithItem)select;
                if (withItem.getSelect() != null) {
                    this.processSelectBody(withItem.getSelect());
                }
            } else {
                SetOperationList operationList = (SetOperationList)select;
                if (operationList.getSelects() != null && !operationList.getSelects().isEmpty()) {
                    List plainSelects = operationList.getSelects();
                    for (Select plainSelect : plainSelects) {
                        this.processSelectBody(plainSelect);
                    }
                }
            }
        }
    }

    public boolean allowProcess(MetaObject metaObject) {
        return true;
    }

    public boolean doFilter(MetaObject metaObject, String sql) {
        return true;
    }

    public void processInsert(Insert insert) {
    }

    public void processDelete(Delete delete) {
        Assert.notNull((Object)delete.getWhere(), (String)"Prohibition of full table deletion", (Object[])new Object[0]);
    }

    public void processUpdate(Update update) {
        Assert.notNull((Object)update.getWhere(), (String)"Prohibition of table update operation", (Object[])new Object[0]);
    }
}

