/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.statement.Statement;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Property;
import org.miaixz.bus.pager.parsing.SqlParser;

public class Builder {
    private static final SqlParser SQL_PARSER;

    public static Statement parse(String statementReader) {
        try {
            return SQL_PARSER.parse(statementReader);
        }
        catch (JSQLParserException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(String classStr, Class<T> spi, Properties properties, Supplier<T> defaultSupplier) {
        ServiceLoader<T> loader;
        Iterator<T> iterator;
        if (StringKit.isNotEmpty((CharSequence)classStr)) {
            try {
                Class<?> cls = Class.forName(classStr);
                return (T)Builder.newInstance(cls, properties);
            }
            catch (Exception cls) {
                // empty catch block
            }
        }
        T result = null;
        if (spi != null && (iterator = (loader = ServiceLoader.load(spi)).iterator()).hasNext()) {
            T t = iterator.next();
            result = t;
        }
        if (result == null) {
            result = defaultSupplier.get();
        }
        if (result instanceof Property) {
            ((Property)result).setProperties(properties);
        }
        return result;
    }

    public static <T> T newInstance(String classStr, Properties properties) {
        try {
            Class<?> cls = Class.forName(classStr);
            return (T)Builder.newInstance(cls, properties);
        }
        catch (Exception e) {
            throw new PageException((Throwable)e);
        }
    }

    public static <T> T newInstance(Class<T> cls, Properties properties) {
        try {
            T instance = cls.newInstance();
            if (instance instanceof Property) {
                ((Property)instance).setProperties(properties);
            }
            return instance;
        }
        catch (Exception e) {
            throw new PageException((Throwable)e);
        }
    }

    public static String current() {
        Exception exception = new Exception("Stack information when setting pagination parameters");
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    static {
        SqlParser temp = null;
        ServiceLoader<SqlParser> loader = ServiceLoader.load(SqlParser.class);
        Iterator<SqlParser> iterator = loader.iterator();
        if (iterator.hasNext()) {
            SqlParser sqlParser;
            temp = sqlParser = iterator.next();
        }
        if (temp == null) {
            temp = SqlParser.DEFAULT;
        }
        SQL_PARSER = temp;
    }
}

