/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.PageContext;
import org.miaixz.bus.pager.Paginating;
import org.miaixz.bus.pager.Querying;
import org.miaixz.bus.pager.Serialize;
import org.miaixz.bus.pager.builder.BoundSqlBuilder;

public class Page<E>
extends ArrayList<E>
implements Closeable {
    private static final long serialVersionUID = 2852289758798L;
    private final String stackTrace = Builder.current();
    private int pageNo;
    private int pageSize;
    private long startRow;
    private long endRow;
    private long total;
    private int pages;
    private boolean count = true;
    private Boolean reasonable;
    private Boolean pageSizeZero;
    private String countColumn;
    private String orderBy;
    private boolean orderByOnly;
    private BoundSqlBuilder boundSqlHandler;
    private transient BoundSqlBuilder.Chain chain;
    private String dialectClass;
    private Boolean keepOrderBy;
    private Boolean keepSubSelectOrderBy;
    private Boolean asyncCount;

    public Page() {
    }

    public Page(int pageNo, int pageSize) {
        this(pageNo, pageSize, true, null);
    }

    public Page(int pageNo, int pageSize, boolean count) {
        this(pageNo, pageSize, count, null);
    }

    private Page(int pageNo, int pageSize, boolean count, Boolean reasonable) {
        super(0);
        if (pageNo == 1 && pageSize == Integer.MAX_VALUE) {
            this.pageSizeZero = true;
            pageSize = 0;
        }
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.count = count;
        this.calculateStartAndEndRow();
        this.setReasonable(reasonable);
    }

    public Page(int[] rowBounds, boolean count) {
        super(0);
        if (rowBounds[0] == 0 && rowBounds[1] == Integer.MAX_VALUE) {
            this.pageSizeZero = true;
            this.pageSize = 0;
            this.pageNo = 1;
        } else {
            this.pageSize = rowBounds[1];
            this.pageNo = rowBounds[1] != 0 ? (int)Math.ceil(((double)rowBounds[0] + (double)rowBounds[1]) / (double)rowBounds[1]) : 0;
        }
        this.startRow = rowBounds[0];
        this.count = count;
        this.endRow = this.startRow + (long)rowBounds[1];
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public List<E> getResult() {
        return this;
    }

    public int getPages() {
        return this.pages;
    }

    public Page<E> setPages(int pages) {
        this.pages = pages;
        return this;
    }

    public long getEndRow() {
        return this.endRow;
    }

    public Page<E> setEndRow(long endRow) {
        this.endRow = endRow;
        return this;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public Page<E> setPageNo(int pageNo) {
        this.pageNo = this.reasonable != null && this.reasonable != false && pageNo <= 0 ? 1 : pageNo;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Page<E> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getStartRow() {
        return this.startRow;
    }

    public Page<E> setStartRow(long startRow) {
        this.startRow = startRow;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
        if (total == -1L) {
            this.pages = 1;
            return;
        }
        this.pages = this.pageSize > 0 ? (int)(total / (long)this.pageSize + (long)(total % (long)this.pageSize == 0L ? 0 : 1)) : 0;
        if (this.reasonable != null && this.reasonable.booleanValue() && this.pageNo > this.pages) {
            if (this.pages != 0) {
                this.pageNo = this.pages;
            }
            this.calculateStartAndEndRow();
        }
    }

    public Boolean getReasonable() {
        return this.reasonable;
    }

    public Page<E> setReasonable(Boolean reasonable) {
        if (reasonable == null) {
            return this;
        }
        this.reasonable = reasonable;
        if (this.reasonable.booleanValue() && this.pageNo <= 0) {
            this.pageNo = 1;
            this.calculateStartAndEndRow();
        }
        return this;
    }

    public Boolean getPageSizeZero() {
        return this.pageSizeZero;
    }

    public Page<E> setPageSizeZero(Boolean pageSizeZero) {
        if (this.pageSizeZero == null && pageSizeZero != null) {
            this.pageSizeZero = pageSizeZero;
        }
        return this;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public <E> Page<E> setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public <E> Page<E> setUnsafeOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public boolean isOrderByOnly() {
        return this.orderByOnly;
    }

    public void setOrderByOnly(boolean orderByOnly) {
        this.orderByOnly = orderByOnly;
    }

    public String getDialectClass() {
        return this.dialectClass;
    }

    public void setDialectClass(String dialectClass) {
        this.dialectClass = dialectClass;
    }

    public Boolean getKeepOrderBy() {
        return this.keepOrderBy;
    }

    public Page<E> setKeepOrderBy(Boolean keepOrderBy) {
        this.keepOrderBy = keepOrderBy;
        return this;
    }

    public Boolean getKeepSubSelectOrderBy() {
        return this.keepSubSelectOrderBy;
    }

    public void setKeepSubSelectOrderBy(Boolean keepSubSelectOrderBy) {
        this.keepSubSelectOrderBy = keepSubSelectOrderBy;
    }

    public Boolean getAsyncCount() {
        return this.asyncCount;
    }

    public void setAsyncCount(Boolean asyncCount) {
        this.asyncCount = asyncCount;
    }

    public Page<E> using(String dialect) {
        this.dialectClass = dialect;
        return this;
    }

    private void calculateStartAndEndRow() {
        this.startRow = this.pageNo > 0 ? (long)((this.pageNo - 1) * this.pageSize) : 0L;
        this.endRow = this.startRow + (long)(this.pageSize * (this.pageNo > 0 ? 1 : 0));
    }

    public boolean isCount() {
        return this.count;
    }

    public Page<E> setCount(boolean count) {
        this.count = count;
        return this;
    }

    public Page<E> pageNo(int pageNo) {
        this.pageNo = this.reasonable != null && this.reasonable != false && pageNo <= 0 ? 1 : pageNo;
        return this;
    }

    public Page<E> pageSize(int pageSize) {
        this.pageSize = pageSize;
        this.calculateStartAndEndRow();
        return this;
    }

    public Page<E> count(Boolean count) {
        this.count = count;
        return this;
    }

    public Page<E> reasonable(Boolean reasonable) {
        this.setReasonable(reasonable);
        return this;
    }

    public Page<E> pageSizeZero(Boolean pageSizeZero) {
        this.setPageSizeZero(pageSizeZero);
        return this;
    }

    public Page<E> boundSqlInterceptor(BoundSqlBuilder boundSqlHandler) {
        this.setBoundSqlInterceptor(boundSqlHandler);
        return this;
    }

    public Page<E> countColumn(String columnName) {
        this.setCountColumn(columnName);
        return this;
    }

    public Page<E> keepOrderBy(boolean keepOrderBy) {
        this.keepOrderBy = keepOrderBy;
        return this;
    }

    public boolean keepOrderBy() {
        return this.keepOrderBy != null && this.keepOrderBy != false;
    }

    public Page<E> keepSubSelectOrderBy(boolean keepSubSelectOrderBy) {
        this.keepSubSelectOrderBy = keepSubSelectOrderBy;
        return this;
    }

    public boolean keepSubSelectOrderBy() {
        return this.keepSubSelectOrderBy != null && this.keepSubSelectOrderBy != false;
    }

    public Page<E> asyncCount(boolean asyncCount) {
        this.asyncCount = asyncCount;
        return this;
    }

    public Page<E> enableAsyncCount() {
        return this.asyncCount(true);
    }

    public Page<E> disableAsyncCount() {
        return this.asyncCount(false);
    }

    public boolean asyncCount() {
        return this.asyncCount != null && this.asyncCount != false;
    }

    public Paginating<E> toPageInfo() {
        return new Paginating(this);
    }

    public <T> Paginating<T> toPageInfo(FunctionX<E, T> function) {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        for (Object e : this) {
            list.add(function.apply(e));
        }
        Paginating paginating = new Paginating(list);
        paginating.setTotal(this.getTotal());
        paginating.setPageNo(this.getPageNo());
        paginating.setPageSize(this.getPageSize());
        paginating.setPages(this.getPages());
        paginating.setStartRow(this.getStartRow());
        paginating.setEndRow(this.getEndRow());
        paginating.calcByNavigatePages(8);
        return paginating;
    }

    public Serialize<E> toPageSerializable() {
        return new Serialize(this);
    }

    public <T> Serialize<T> toPageSerializable(FunctionX<E, T> function) {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        for (Object e : this) {
            list.add(function.apply(e));
        }
        Serialize serialize = new Serialize(list);
        serialize.setTotal(this.getTotal());
        return serialize;
    }

    public <E> Page<E> doSelectPage(Querying select) {
        select.doSelect();
        return this;
    }

    public <E> Paginating<E> doSelectPageInfo(Querying select) {
        select.doSelect();
        return this.toPageInfo();
    }

    public <E> Serialize<E> doSelectPageSerializable(Querying select) {
        select.doSelect();
        return this.toPageSerializable();
    }

    public long doCount(Querying select) {
        this.pageSizeZero = true;
        this.pageSize = 0;
        select.doSelect();
        return this.total;
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    public void setCountColumn(String countColumn) {
        this.countColumn = countColumn;
    }

    public BoundSqlBuilder getBoundSqlInterceptor() {
        return this.boundSqlHandler;
    }

    public void setBoundSqlInterceptor(BoundSqlBuilder boundSqlHandler) {
        this.boundSqlHandler = boundSqlHandler;
    }

    BoundSqlBuilder.Chain getChain() {
        return this.chain;
    }

    void setChain(BoundSqlBuilder.Chain chain) {
        this.chain = chain;
    }

    @Override
    public String toString() {
        return "Page{count=" + this.count + ", pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", startRow=" + this.startRow + ", endRow=" + this.endRow + ", total=" + this.total + ", pages=" + this.pages + ", reasonable=" + this.reasonable + ", pageSizeZero=" + this.pageSizeZero + "}" + super.toString();
    }

    @Override
    public void close() {
        PageContext.clearPage();
    }
}

