/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Dialect;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.binding.PageAutoDialect;
import org.miaixz.bus.pager.binding.PageMethod;
import org.miaixz.bus.pager.binding.PageParams;
import org.miaixz.bus.pager.builder.BoundSqlBuilder;
import org.miaixz.bus.pager.builder.BoundSqlChainBuilder;
import org.miaixz.bus.pager.builder.PageBoundSqlBuilder;
import org.miaixz.bus.pager.dialect.AbstractPaging;
import org.miaixz.bus.pager.parsing.CountSqlParser;

public class PageContext
extends PageMethod
implements Dialect,
BoundSqlBuilder.Chain {
    private PageParams pageParams;
    private PageAutoDialect autoDialect;
    private PageBoundSqlBuilder pageBoundSqlBuilder;
    private ForkJoinPool asyncCountService;

    @Override
    public boolean skip(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        Page page = this.pageParams.getPage(parameterObject, rowBounds);
        if (page == null) {
            return true;
        }
        if (StringKit.isEmpty((CharSequence)page.getCountColumn())) {
            page.setCountColumn(this.pageParams.getCountColumn());
        }
        if (page.getAsyncCount() == null) {
            page.setAsyncCount(this.pageParams.isAsyncCount());
        }
        this.autoDialect.initDelegateDialect(ms, page.getDialectClass());
        return false;
    }

    @Override
    public boolean isAsyncCount() {
        return PageContext.getLocalPage().asyncCount();
    }

    @Override
    public <T> Future<T> asyncCountTask(Callable<T> task) {
        AbstractPaging dialectThreadLocal = this.autoDialect.getDialectThreadLocal();
        Page localPage = PageContext.getLocalPage();
        String countId = UUID.randomUUID().toString();
        return this.asyncCountService.submit(() -> {
            try {
                this.autoDialect.setDialectThreadLocal(dialectThreadLocal);
                PageContext.setLocalPage(localPage);
                Object v = task.call();
                return v;
            }
            finally {
                this.autoDialect.clearDelegate();
                PageContext.clearPage();
            }
        });
    }

    @Override
    public boolean beforeCount(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.autoDialect.getDelegate().beforeCount(ms, parameterObject, rowBounds);
    }

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        return this.autoDialect.getDelegate().getCountSql(ms, boundSql, parameterObject, rowBounds, countKey);
    }

    @Override
    public boolean afterCount(long count, Object parameterObject, RowBounds rowBounds) {
        return this.autoDialect.getDelegate().afterCount(count, parameterObject, rowBounds);
    }

    @Override
    public Object processParameterObject(MappedStatement ms, Object parameterObject, BoundSql boundSql, CacheKey pageKey) {
        return this.autoDialect.getDelegate().processParameterObject(ms, parameterObject, boundSql, pageKey);
    }

    @Override
    public boolean beforePage(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return this.autoDialect.getDelegate().beforePage(ms, parameterObject, rowBounds);
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        return this.autoDialect.getDelegate().getPageSql(ms, boundSql, parameterObject, rowBounds, pageKey);
    }

    public String getPageSql(String sql, Page page, RowBounds rowBounds, CacheKey pageKey) {
        return this.autoDialect.getDelegate().getPageSql(sql, page, pageKey);
    }

    @Override
    public Object afterPage(List pageList, Object parameterObject, RowBounds rowBounds) {
        AbstractPaging delegate = this.autoDialect.getDelegate();
        if (delegate != null) {
            return delegate.afterPage(pageList, parameterObject, rowBounds);
        }
        return pageList;
    }

    @Override
    public void afterAll() {
        AbstractPaging delegate = this.autoDialect.getDelegate();
        if (delegate != null) {
            delegate.afterAll();
            this.autoDialect.clearDelegate();
        }
        PageContext.clearPage();
    }

    @Override
    public BoundSql doBoundSql(BoundSqlBuilder.Type type, BoundSql boundSql, CacheKey cacheKey) {
        BoundSqlBuilder.Chain chain;
        Page localPage = PageContext.getLocalPage();
        BoundSqlBuilder.Chain chain2 = chain = localPage != null ? localPage.getChain() : null;
        if (chain == null) {
            BoundSqlBuilder.Chain defaultChain;
            BoundSqlBuilder boundSqlHandler = localPage != null ? localPage.getBoundSqlInterceptor() : null;
            BoundSqlBuilder.Chain chain3 = defaultChain = this.pageBoundSqlBuilder != null ? this.pageBoundSqlBuilder.getChain() : null;
            if (boundSqlHandler != null) {
                chain = new BoundSqlChainBuilder(defaultChain, Arrays.asList(boundSqlHandler));
            } else if (defaultChain != null) {
                chain = defaultChain;
            }
            if (chain == null) {
                chain = DO_NOTHING;
            }
            if (localPage != null) {
                localPage.setChain(chain);
            }
        }
        return chain.doBoundSql(type, boundSql, cacheKey);
    }

    @Override
    public void setProperties(Properties properties) {
        PageContext.setStaticProperties(properties);
        this.pageParams = new PageParams();
        this.autoDialect = new PageAutoDialect();
        this.pageBoundSqlBuilder = new PageBoundSqlBuilder();
        this.pageParams.setProperties(properties);
        this.autoDialect.setProperties(properties);
        this.pageBoundSqlBuilder.setProperties(properties);
        CountSqlParser.addAggregateFunctions(properties.getProperty("aggregateFunctions"));
        int asyncCountParallelism = Integer.parseInt(properties.getProperty("asyncCountParallelism", "" + Runtime.getRuntime().availableProcessors() * 2));
        this.asyncCountService = new ForkJoinPool(asyncCountParallelism, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("pager-async-count-" + worker.getPoolIndex());
            return worker;
        }, null, true);
    }
}

