/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.binding;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.pager.Dialect;
import org.miaixz.bus.pager.builder.BoundSqlBuilder;

public abstract class CountExecutor {
    private static Field additionalParametersField;
    private static Field providerMethodArgumentNamesField;

    public static Map<String, Object> getAdditionalParameter(BoundSql boundSql) {
        try {
            return (Map)additionalParametersField.get(boundSql);
        }
        catch (IllegalAccessException e) {
            throw new PageException("Failed to get the BoundSql property additionalParameters: " + String.valueOf(e), (Throwable)e);
        }
    }

    public static String[] getProviderMethodArgumentNames(ProviderSqlSource providerSqlSource) {
        try {
            return providerMethodArgumentNamesField != null ? (String[])providerMethodArgumentNamesField.get(providerSqlSource) : null;
        }
        catch (IllegalAccessException e) {
            throw new PageException("Get the ProviderSqlSource property value of providerMethodArgumentNames: " + String.valueOf(e), (Throwable)e);
        }
    }

    public static MappedStatement getExistedMappedStatement(Configuration configuration, String msId) {
        MappedStatement mappedStatement = null;
        try {
            mappedStatement = configuration.getMappedStatement(msId, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mappedStatement;
    }

    public static Long executeManualCount(Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, ResultHandler resultHandler) throws SQLException {
        BoundSql countBoundSql;
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        List countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql = countMs.getBoundSql(parameter));
        if (countResultList == null || countResultList.isEmpty()) {
            return 0L;
        }
        return ((Number)countResultList.get(0)).longValue();
    }

    public static Long executeAutoCount(Dialect dialect, Executor executor, MappedStatement countMs, Object parameter, BoundSql boundSql, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        List countResultList;
        Map<String, Object> additionalParameters = CountExecutor.getAdditionalParameter(boundSql);
        CacheKey countKey = executor.createCacheKey(countMs, parameter, RowBounds.DEFAULT, boundSql);
        String countSql = dialect.getCountSql(countMs, boundSql, parameter, rowBounds, countKey);
        BoundSql countBoundSql = new BoundSql(countMs.getConfiguration(), countSql, boundSql.getParameterMappings(), parameter);
        for (String key : additionalParameters.keySet()) {
            countBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
        }
        if (dialect instanceof BoundSqlBuilder.Chain) {
            countBoundSql = ((BoundSqlBuilder.Chain)((Object)dialect)).doBoundSql(BoundSqlBuilder.Type.COUNT_SQL, countBoundSql, countKey);
        }
        if ((countResultList = executor.query(countMs, parameter, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql)) == null || countResultList.isEmpty()) {
            return 0L;
        }
        return ((Number)countResultList.get(0)).longValue();
    }

    public static <E> List<E> pageQuery(Dialect dialect, Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql, CacheKey cacheKey) throws SQLException {
        if (dialect.beforePage(ms, parameter, rowBounds)) {
            parameter = dialect.processParameterObject(ms, parameter, boundSql, cacheKey);
            String pageSql = dialect.getPageSql(ms, boundSql, parameter, rowBounds, cacheKey);
            Map<String, Object> additionalParameters = CountExecutor.getAdditionalParameter(boundSql);
            boundSql = new BoundSql(ms.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameter);
            for (String key : additionalParameters.keySet()) {
                boundSql.setAdditionalParameter(key, additionalParameters.get(key));
            }
            if (dialect instanceof BoundSqlBuilder.Chain) {
                boundSql = ((BoundSqlBuilder.Chain)((Object)dialect)).doBoundSql(BoundSqlBuilder.Type.PAGE_SQL, boundSql, cacheKey);
            }
            return executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, cacheKey, boundSql);
        }
        return executor.query(ms, parameter, RowBounds.DEFAULT, resultHandler, cacheKey, boundSql);
    }

    static {
        try {
            additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new PageException("Failed to get the BoundSql property additionalParameters: " + String.valueOf(e), (Throwable)e);
        }
        try {
            providerMethodArgumentNamesField = ProviderSqlSource.class.getDeclaredField("providerMethodArgumentNames");
            providerMethodArgumentNamesField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

