/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.binding;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.Dialect;
import org.miaixz.bus.pager.dialect.AbstractPaging;
import org.miaixz.bus.pager.dialect.AutoDialect;
import org.miaixz.bus.pager.dialect.auto.Defalut;
import org.miaixz.bus.pager.dialect.auto.Druid;
import org.miaixz.bus.pager.dialect.auto.Early;
import org.miaixz.bus.pager.dialect.auto.Hikari;
import org.miaixz.bus.pager.dialect.base.AS400;
import org.miaixz.bus.pager.dialect.base.CirroData;
import org.miaixz.bus.pager.dialect.base.Db2;
import org.miaixz.bus.pager.dialect.base.Firebird;
import org.miaixz.bus.pager.dialect.base.HerdDB;
import org.miaixz.bus.pager.dialect.base.Hsqldb;
import org.miaixz.bus.pager.dialect.base.Informix;
import org.miaixz.bus.pager.dialect.base.MySql;
import org.miaixz.bus.pager.dialect.base.Oracle;
import org.miaixz.bus.pager.dialect.base.Oracle9i;
import org.miaixz.bus.pager.dialect.base.Oscar;
import org.miaixz.bus.pager.dialect.base.PostgreSql;
import org.miaixz.bus.pager.dialect.base.SqlServer;
import org.miaixz.bus.pager.dialect.base.SqlServer2012;
import org.miaixz.bus.pager.dialect.base.Xugudb;

public class PageAutoDialect {
    private static Map<String, Class<? extends Dialect>> dialectAliasMap = new LinkedHashMap<String, Class<? extends Dialect>>();
    private static Map<String, Class<? extends AutoDialect>> autoDialectMap = new LinkedHashMap<String, Class<? extends AutoDialect>>();
    private boolean autoDialect = true;
    private Map<Object, AbstractPaging> urlDialectMap = new ConcurrentHashMap<Object, AbstractPaging>();
    private ThreadLocal<AbstractPaging> dialectThreadLocal = new ThreadLocal();
    private Properties properties;
    private AutoDialect autoDialectDelegate;
    private ReentrantLock lock = new ReentrantLock();
    private AbstractPaging delegate;

    public static void registerDialectAlias(String alias, Class<? extends Dialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public static void registerAutoDialectAlias(String alias, Class<? extends AutoDialect> autoDialectClass) {
        autoDialectMap.put(alias, autoDialectClass);
    }

    public static String fromJdbcUrl(String jdbcUrl) {
        String url = jdbcUrl.toLowerCase();
        for (String dialect : dialectAliasMap.keySet()) {
            if (!url.contains(":" + dialect.toLowerCase() + ":")) continue;
            return dialect;
        }
        return null;
    }

    public static Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    public static AbstractPaging instanceDialect(String dialectClass, Properties properties) {
        AbstractPaging dialect;
        if (StringKit.isEmpty((CharSequence)dialectClass)) {
            throw new PageException("When you use the PageContext pagination handler, you must set the basic property");
        }
        try {
            Class sqlDialectClass = PageAutoDialect.resloveDialectClass(dialectClass);
            if (!AbstractPaging.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("When using PageContext, the dialect must be an implementation class that implements the " + AbstractPaging.class.getCanonicalName() + " interface!");
            }
            dialect = (AbstractPaging)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("error initializing basic dialectclass[" + dialectClass + "]" + e.getMessage(), (Throwable)e);
        }
        dialect.setProperties(properties);
        return dialect;
    }

    public AbstractPaging getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    public AbstractPaging getDialectThreadLocal() {
        return this.dialectThreadLocal.get();
    }

    public void setDialectThreadLocal(AbstractPaging delegate) {
        this.dialectThreadLocal.set(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDelegateDialect(MappedStatement ms, String dialectClass) {
        if (StringKit.isNotEmpty((CharSequence)dialectClass)) {
            AbstractPaging dialect = this.urlDialectMap.get(dialectClass);
            if (dialect == null) {
                this.lock.lock();
                try {
                    dialect = this.urlDialectMap.get(dialectClass);
                    if (dialect == null) {
                        dialect = PageAutoDialect.instanceDialect(dialectClass, this.properties);
                        this.urlDialectMap.put(dialectClass, dialect);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.dialectThreadLocal.set(dialect);
        } else if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.autoGetDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.autoGetDialect(ms));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPaging autoGetDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        Object dialectKey = this.autoDialectDelegate.extractDialectKey(ms, dataSource, this.properties);
        if (dialectKey == null) {
            return this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties);
        }
        if (!this.urlDialectMap.containsKey(dialectKey)) {
            this.lock.lock();
            try {
                if (!this.urlDialectMap.containsKey(dialectKey)) {
                    this.urlDialectMap.put(dialectKey, this.autoDialectDelegate.extractDialect(dialectKey, ms, dataSource, this.properties));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.urlDialectMap.get(dialectKey);
    }

    private void initAutoDialectClass(Properties properties) {
        String autoDialectClassStr = properties.getProperty("autoDialectClass");
        if (StringKit.isNotEmpty((CharSequence)autoDialectClassStr)) {
            try {
                Class<Object> autoDialectClass = autoDialectMap.containsKey(autoDialectClassStr) ? autoDialectMap.get(autoDialectClassStr) : Class.forName(autoDialectClassStr);
                this.autoDialectDelegate = (AutoDialect)Builder.newInstance(autoDialectClass, properties);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Make sure that the AutoDialect implementation class (" + autoDialectClassStr + ") for the autoDialectClass configuration exists!", e);
            }
            catch (Exception e) {
                throw new RuntimeException(autoDialectClassStr + "Class must provide a constructor without parameters", e);
            }
        } else {
            this.autoDialectDelegate = new Defalut();
        }
    }

    private void initDialectAlias(Properties properties) {
        String dialectAlias = properties.getProperty("dialectAlias");
        if (StringKit.isNotEmpty((CharSequence)dialectAlias)) {
            String[] alias = dialectAlias.split(";");
            for (int i = 0; i < alias.length; ++i) {
                String[] kv = alias[i].split("=");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("dialectAlias parameter misconfigured,Please follow alias1=xx.dialectClass; alias2=dialectClass2!");
                }
                for (int j = 0; j < kv.length; ++j) {
                    try {
                        if (dialectAliasMap.containsKey(kv[1])) {
                            PageAutoDialect.registerDialectAlias(kv[0], dialectAliasMap.get(kv[1]));
                            continue;
                        }
                        Class<?> diallectClass = Class.forName(kv[1]);
                        PageAutoDialect.registerDialectAlias(kv[0], diallectClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Make sure the Dialect implementation class configured by dialectAlias exists!", e);
                    }
                }
            }
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.initAutoDialectClass(properties);
        String useSqlserver2012 = properties.getProperty("useSqlserver2012");
        if (StringKit.isNotEmpty((CharSequence)useSqlserver2012) && Boolean.parseBoolean(useSqlserver2012)) {
            PageAutoDialect.registerDialectAlias("sqlserver", SqlServer2012.class);
            PageAutoDialect.registerDialectAlias("sqlserver2008", SqlServer.class);
        }
        this.initDialectAlias(properties);
        String dialect = properties.getProperty("pagerDialect");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringKit.isNotEmpty((CharSequence)runtimeDialect) && "TRUE".equalsIgnoreCase(runtimeDialect)) {
            this.autoDialect = false;
        } else if (StringKit.isEmpty((CharSequence)dialect)) {
            this.autoDialect = true;
        } else {
            this.autoDialect = false;
            this.delegate = PageAutoDialect.instanceDialect(dialect, properties);
        }
    }

    static {
        PageAutoDialect.registerDialectAlias("hsqldb", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("h2", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("phoenix", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("postgresql", PostgreSql.class);
        PageAutoDialect.registerDialectAlias("mysql", MySql.class);
        PageAutoDialect.registerDialectAlias("mariadb", MySql.class);
        PageAutoDialect.registerDialectAlias("sqlite", MySql.class);
        PageAutoDialect.registerDialectAlias("herddb", HerdDB.class);
        PageAutoDialect.registerDialectAlias("oracle", Oracle.class);
        PageAutoDialect.registerDialectAlias("oracle9i", Oracle9i.class);
        PageAutoDialect.registerDialectAlias("db2", Db2.class);
        PageAutoDialect.registerDialectAlias("as400", AS400.class);
        PageAutoDialect.registerDialectAlias("informix", Informix.class);
        PageAutoDialect.registerDialectAlias("informix-sqli", Informix.class);
        PageAutoDialect.registerDialectAlias("sqlserver", SqlServer.class);
        PageAutoDialect.registerDialectAlias("sqlserver2012", SqlServer2012.class);
        PageAutoDialect.registerDialectAlias("derby", SqlServer2012.class);
        PageAutoDialect.registerDialectAlias("dm", Oracle.class);
        PageAutoDialect.registerDialectAlias("edb", Oracle.class);
        PageAutoDialect.registerDialectAlias("oscar", Oscar.class);
        PageAutoDialect.registerDialectAlias("clickhouse", MySql.class);
        PageAutoDialect.registerDialectAlias("highgo", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("xugu", Xugudb.class);
        PageAutoDialect.registerDialectAlias("impala", Hsqldb.class);
        PageAutoDialect.registerDialectAlias("firebirdsql", Firebird.class);
        PageAutoDialect.registerDialectAlias("kingbase", PostgreSql.class);
        PageAutoDialect.registerDialectAlias("kingbase8", PostgreSql.class);
        PageAutoDialect.registerDialectAlias("xcloud", CirroData.class);
        PageAutoDialect.registerDialectAlias("opengauss", PostgreSql.class);
        PageAutoDialect.registerDialectAlias("sundb", Oracle.class);
        PageAutoDialect.registerAutoDialectAlias("old", Early.class);
        PageAutoDialect.registerAutoDialectAlias("hikari", Hikari.class);
        PageAutoDialect.registerAutoDialectAlias("druid", Druid.class);
        PageAutoDialect.registerAutoDialectAlias("default", Defalut.class);
    }
}

