/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.cache;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.cache.metric.CaffeineCache;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Property;
import org.miaixz.bus.pager.cache.SimpleCache;

public abstract class CacheFactory {
    public static <K, V> CacheX<K, V> createCache(String sqlCacheClass, String prefix, Properties properties) {
        if (ObjectKit.isEmpty((Object)properties)) {
            throw new PageException("Properties is empty");
        }
        properties.setProperty("prefix", (String)(StringKit.isNotEmpty((CharSequence)prefix) ? prefix + "." : ""));
        if (StringKit.isEmpty((CharSequence)sqlCacheClass)) {
            try {
                return new CaffeineCache(properties);
            }
            catch (Throwable t) {
                return new SimpleCache(properties);
            }
        }
        try {
            Class<?> clazz = Class.forName(sqlCacheClass);
            try {
                Constructor<?> constructor = clazz.getConstructor(Properties.class, String.class);
                return (CacheX)constructor.newInstance(properties);
            }
            catch (Exception e) {
                CacheX cache = (CacheX)clazz.newInstance();
                if (cache instanceof Property) {
                    ((Property)cache).setProperties(properties);
                }
                return cache;
            }
        }
        catch (Throwable t) {
            throw new PageException("Created Sql Cache [" + sqlCacheClass + "] Error", t);
        }
    }
}

