/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.FifoCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.mapping.CacheBuilder;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.xyz.StringKit;

public class SimpleCache<K, V>
implements CacheX<K, V> {
    private final Cache CACHE;

    public SimpleCache(Properties properties) {
        String size;
        String prefix = StringKit.isNotEmpty((CharSequence)properties.getProperty("prefix")) ? properties.getProperty("prefix") : "";
        CacheBuilder cacheBuilder = new CacheBuilder("SQL_CACHE");
        String typeClass = properties.getProperty(prefix + "typeClass");
        if (StringKit.isNotEmpty((CharSequence)typeClass)) {
            try {
                cacheBuilder.implementation(Class.forName(typeClass));
            }
            catch (ClassNotFoundException e) {
                cacheBuilder.implementation(PerpetualCache.class);
            }
        } else {
            cacheBuilder.implementation(PerpetualCache.class);
        }
        String evictionClass = properties.getProperty(prefix + "evictionClass");
        if (StringKit.isNotEmpty((CharSequence)evictionClass)) {
            try {
                cacheBuilder.addDecorator(Class.forName(evictionClass));
            }
            catch (ClassNotFoundException e) {
                cacheBuilder.addDecorator(FifoCache.class);
            }
        } else {
            cacheBuilder.addDecorator(FifoCache.class);
        }
        String flushInterval = properties.getProperty(prefix + "flushInterval");
        if (StringKit.isNotEmpty((CharSequence)flushInterval)) {
            cacheBuilder.clearInterval(Long.valueOf(Long.parseLong(flushInterval)));
        }
        if (StringKit.isNotEmpty((CharSequence)(size = properties.getProperty(prefix + "size")))) {
            cacheBuilder.size(Integer.valueOf(Integer.parseInt(size)));
        }
        cacheBuilder.properties(properties);
        this.CACHE = cacheBuilder.build();
    }

    public V read(K key) {
        Object value = this.CACHE.getObject(key);
        if (null != value) {
            return (V)value;
        }
        return null;
    }

    public Map<K, V> read(Collection<K> keys) {
        return Map.of();
    }

    public void write(K key, V value, long expire) {
        this.CACHE.putObject(key, value);
    }

    public void write(Map<K, V> map, long expire) {
    }

    public void remove(K ... keys) {
    }

    public void clear() {
    }
}

