/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.dialect.auto;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.miaixz.bus.core.lang.exception.PageException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.binding.PageAutoDialect;
import org.miaixz.bus.pager.dialect.AbstractPaging;
import org.miaixz.bus.pager.dialect.AutoDialect;

public class Early
implements AutoDialect<String> {
    public static final AutoDialect<String> DEFAULT = new Early();

    @Override
    public String extractDialectKey(MappedStatement ms, DataSource dataSource, Properties properties) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    String closeConn = properties.getProperty("closeConn");
                    if (StringKit.isEmpty((CharSequence)closeConn) || Boolean.parseBoolean(closeConn)) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public AbstractPaging extractDialect(String dialectKey, MappedStatement ms, DataSource dataSource, Properties properties) {
        String dialectStr = PageAutoDialect.fromJdbcUrl(dialectKey);
        if (dialectStr == null) {
            throw new PageException("The database type cannot be obtained automatically, please specify it via the pagerDialect parameter!");
        }
        return PageAutoDialect.instanceDialect(dialectStr, properties);
    }
}

