/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.dialect.base;

import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.cache.CacheFactory;
import org.miaixz.bus.pager.dialect.AbstractPaging;
import org.miaixz.bus.pager.dialect.ReplaceSql;
import org.miaixz.bus.pager.dialect.replace.RegexWithNolock;
import org.miaixz.bus.pager.dialect.replace.SimpleWithNolock;
import org.miaixz.bus.pager.parsing.DefaultSqlServerSqlParser;
import org.miaixz.bus.pager.parsing.SqlServerSqlParser;

public class SqlServer
extends AbstractPaging {
    protected SqlServerSqlParser sqlServerSqlParser;
    protected CacheX<String, String> CACHE_COUNTSQL;
    protected CacheX<String, String> CACHE_PAGESQL;
    protected ReplaceSql replaceSql;

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        String sql = boundSql.getSql();
        String cacheSql = (String)this.CACHE_COUNTSQL.read((Object)sql);
        if (cacheSql != null) {
            return cacheSql;
        }
        cacheSql = sql;
        cacheSql = this.replaceSql.replace(cacheSql);
        cacheSql = this.countSqlParser.getSmartCountSql(cacheSql);
        cacheSql = this.replaceSql.restore(cacheSql);
        this.CACHE_COUNTSQL.write((Object)sql, (Object)cacheSql, 60L);
        return cacheSql;
    }

    @Override
    public Object processPageParameter(MappedStatement ms, Map<String, Object> paramMap, Page page, BoundSql boundSql, CacheKey pageKey) {
        return paramMap;
    }

    @Override
    public String getPageSql(String sql, Page page, CacheKey pageKey) {
        pageKey.update((Object)page.getStartRow());
        pageKey.update((Object)page.getPageSize());
        String cacheSql = (String)this.CACHE_PAGESQL.read((Object)sql);
        if (cacheSql == null) {
            cacheSql = sql;
            cacheSql = this.replaceSql.replace(cacheSql);
            cacheSql = this.sqlServerSqlParser.convertToPageSql(cacheSql, null, null);
            cacheSql = this.replaceSql.restore(cacheSql);
            this.CACHE_PAGESQL.write((Object)sql, (Object)cacheSql, 60L);
        }
        cacheSql = cacheSql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(page.getStartRow()));
        cacheSql = cacheSql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(page.getPageSize()));
        return cacheSql;
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        Page page = this.getLocalPage();
        String orderBy = page.getOrderBy();
        if (StringKit.isNotEmpty((CharSequence)orderBy)) {
            pageKey.update((Object)orderBy);
            sql = this.replaceSql.replace(sql);
            sql = this.orderBySqlParser.converToOrderBySql(sql, orderBy);
            sql = this.replaceSql.restore(sql);
        }
        return page.isOrderByOnly() ? sql : this.getPageSql(sql, page, pageKey);
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.sqlServerSqlParser = Builder.newInstance(properties.getProperty("sqlServerSqlParser"), SqlServerSqlParser.class, properties, DefaultSqlServerSqlParser::new);
        String replaceSql = properties.getProperty("replaceSql");
        this.replaceSql = StringKit.isEmpty((CharSequence)replaceSql) || "regex".equalsIgnoreCase(replaceSql) ? new RegexWithNolock() : ("simple".equalsIgnoreCase(replaceSql) ? new SimpleWithNolock() : (ReplaceSql)Builder.newInstance(replaceSql, properties));
        String sqlCacheClass = properties.getProperty("sqlCacheClass");
        if (StringKit.isNotEmpty((CharSequence)sqlCacheClass) && !sqlCacheClass.equalsIgnoreCase("false")) {
            this.CACHE_COUNTSQL = CacheFactory.createCache(sqlCacheClass, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(sqlCacheClass, "pages", properties);
        } else {
            this.CACHE_COUNTSQL = CacheFactory.createCache(null, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(null, "pages", properties);
        }
    }
}

