/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.dialect.rowbounds;

import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.dialect.AbstractRowBounds;
import org.miaixz.bus.pager.dialect.ReplaceSql;
import org.miaixz.bus.pager.dialect.replace.RegexWithNolock;
import org.miaixz.bus.pager.dialect.replace.SimpleWithNolock;
import org.miaixz.bus.pager.parsing.DefaultSqlServerSqlParser;
import org.miaixz.bus.pager.parsing.SqlServerSqlParser;

public class SqlServerRowBounds
extends AbstractRowBounds {
    protected SqlServerSqlParser sqlServerSqlParser;
    protected ReplaceSql replaceSql;

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        String sql = boundSql.getSql();
        sql = this.replaceSql.replace(sql);
        sql = this.countSqlParser.getSmartCountSql(sql);
        sql = this.replaceSql.restore(sql);
        return sql;
    }

    @Override
    public String getPageSql(String sql, RowBounds rowBounds, CacheKey pageKey) {
        pageKey.update((Object)rowBounds.getOffset());
        pageKey.update((Object)rowBounds.getLimit());
        sql = this.replaceSql.replace(sql);
        sql = this.sqlServerSqlParser.convertToPageSql(sql, null, null);
        sql = this.replaceSql.restore(sql);
        sql = sql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(rowBounds.getOffset()));
        sql = sql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(rowBounds.getLimit()));
        return sql;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.sqlServerSqlParser = Builder.newInstance(properties.getProperty("sqlServerSqlParser"), SqlServerSqlParser.class, properties, DefaultSqlServerSqlParser::new);
        String replaceSql = properties.getProperty("replaceSql");
        this.replaceSql = StringKit.isEmpty((CharSequence)replaceSql) || "simple".equalsIgnoreCase(replaceSql) ? new SimpleWithNolock() : ("regex".equalsIgnoreCase(replaceSql) ? new RegexWithNolock() : (ReplaceSql)Builder.newInstance(replaceSql, properties));
    }
}

