/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.handler;

import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.builder.EntityClassBuilder;
import org.miaixz.bus.mapper.handler.MapperHandler;
import org.miaixz.bus.pager.handler.SqlParserHandler;

public class OperationHandler<T>
extends SqlParserHandler
implements MapperHandler<T> {
    public void prepare(StatementHandler statementHandler) {
        MetaObject metaObject = OperationHandler.getMetaObject((Object)statementHandler);
        MappedStatement ms = OperationHandler.getMappedStatement((MetaObject)metaObject);
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
            this.parserMulti(boundSql.getSql(), null);
        }
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        this.checkWhere(delete.getTable().getName(), delete.getWhere(), "Prohibition of full table deletion");
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        this.checkWhere(update.getTable().getName(), update.getWhere(), "Prohibition of table update operation");
    }

    protected void checkWhere(String tableName, Expression where, String ex) {
        Assert.isFalse((boolean)this.fullMatch(where, EntityClassBuilder.getTableLogicColumn()), (String)ex, (Object[])new Object[0]);
    }

    private boolean fullMatch(Expression where, String column) {
        if (where == null) {
            return true;
        }
        if (StringKit.isNotBlank((CharSequence)column)) {
            BinaryExpression binaryExpression;
            if (where instanceof BinaryExpression && (StringKit.equals((CharSequence)(binaryExpression = (BinaryExpression)where).getLeftExpression().toString(), (CharSequence)column) || StringKit.equals((CharSequence)binaryExpression.getRightExpression().toString(), (CharSequence)column))) {
                return true;
            }
            if (where instanceof IsNullExpression && StringKit.equals((CharSequence)(binaryExpression = (IsNullExpression)where).getLeftExpression().toString(), (CharSequence)column)) {
                return true;
            }
        }
        if (where instanceof EqualsTo) {
            EqualsTo equalsTo = (EqualsTo)where;
            return StringKit.equals((CharSequence)equalsTo.getLeftExpression().toString(), (CharSequence)equalsTo.getRightExpression().toString());
        }
        if (where instanceof NotEqualsTo) {
            NotEqualsTo notEqualsTo = (NotEqualsTo)where;
            return !StringKit.equals((CharSequence)notEqualsTo.getLeftExpression().toString(), (CharSequence)notEqualsTo.getRightExpression().toString());
        }
        if (where instanceof OrExpression) {
            OrExpression orExpression = (OrExpression)where;
            return this.fullMatch(orExpression.getLeftExpression(), column) || this.fullMatch(orExpression.getRightExpression(), column);
        }
        if (where instanceof AndExpression) {
            AndExpression andExpression = (AndExpression)where;
            return this.fullMatch(andExpression.getLeftExpression(), column) && this.fullMatch(andExpression.getRightExpression(), column);
        }
        if (where instanceof ParenthesedExpressionList) {
            ParenthesedExpressionList parenthesis = (ParenthesedExpressionList)where;
            return this.fullMatch((Expression)parenthesis.get(0), column);
        }
        return false;
    }
}

