/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.handler;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.handler.MapperHandler;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.Dialect;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.binding.CountExecutor;
import org.miaixz.bus.pager.binding.CountMappedStatement;
import org.miaixz.bus.pager.binding.CountMsId;
import org.miaixz.bus.pager.binding.PageMethod;
import org.miaixz.bus.pager.builder.BoundSqlBuilder;
import org.miaixz.bus.pager.cache.CacheFactory;
import org.miaixz.bus.pager.handler.SqlParserHandler;

public class PaginationHandler
extends SqlParserHandler
implements MapperHandler {
    private CacheX<String, MappedStatement> msCountMap;
    private CountMsId countMsId = CountMsId.DEFAULT;
    private volatile Dialect dialect;
    private String countSuffix = "_COUNT";
    private boolean debug;
    private final String default_dialect_class = "org.miaixz.bus.pager.PageContext";

    public boolean isDebug() {
        return this.debug;
    }

    protected void debugStackTraceLog() {
        if (this.isDebug()) {
            Page page = PageMethod.getLocalPage();
            Logger.debug((String)"Pagination call stack: {}", (Object[])new Object[]{page.getStackTrace()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkDialectExists() {
        if (this.dialect != null) return;
        String string = "org.miaixz.bus.pager.PageContext";
        synchronized ("org.miaixz.bus.pager.PageContext") {
            if (this.dialect != null) return;
            this.setProperties(new Properties());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isQuery(Executor executor, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        Page page = PageMethod.getLocalPage();
        if (page == null || page.getPageSize() < 0 || resultHandler != Executor.NO_RESULT_HANDLER) {
            return true;
        }
        this.checkDialectExists();
        if (!this.dialect.skip(mappedStatement, parameter, rowBounds)) {
            try {
                String sql = boundSql.getSql();
                if (StringKit.isBlank((CharSequence)sql)) {
                    Logger.warn((String)"Empty SQL detected, MappedStatement: {}", (Object[])new Object[]{mappedStatement.getId()});
                    return false;
                }
                this.parserSingle(sql, parameter);
                return true;
            }
            catch (Exception e) {
                Logger.error((String)"Failed to parse query SQL: {}", (Object[])new Object[]{e.getMessage()});
                return false;
            }
        }
        return false;
    }

    public void query(Object result, Executor executor, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        try {
            List resultList;
            CacheKey cacheKey = executor.createCacheKey(mappedStatement, parameter, rowBounds, boundSql);
            this.checkDialectExists();
            if (this.dialect instanceof BoundSqlBuilder.Chain) {
                boundSql = ((BoundSqlBuilder.Chain)((Object)this.dialect)).doBoundSql(BoundSqlBuilder.Type.ORIGINAL, boundSql, cacheKey);
            }
            if (!this.dialect.skip(mappedStatement, parameter, rowBounds)) {
                Long count;
                this.debugStackTraceLog();
                Future<Long> countFuture = null;
                if (this.dialect.beforeCount(mappedStatement, parameter, rowBounds)) {
                    if (this.dialect.isAsyncCount()) {
                        countFuture = this.asyncCount(mappedStatement, boundSql, parameter, rowBounds);
                    } else {
                        count = this.count(executor, mappedStatement, parameter, rowBounds, null, boundSql);
                        if (!this.dialect.afterCount(count, parameter, rowBounds)) {
                            ((Object[])result)[0] = this.dialect.afterPage(new ArrayList(), parameter, rowBounds);
                            return;
                        }
                    }
                }
                resultList = CountExecutor.pageQuery(this.dialect, executor, mappedStatement, parameter, rowBounds, resultHandler, boundSql, cacheKey);
                if (countFuture != null) {
                    count = countFuture.get();
                    this.dialect.afterCount(count, parameter, rowBounds);
                }
            } else {
                resultList = executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
            }
            ((Object[])result)[0] = this.dialect.afterPage(resultList, parameter, rowBounds);
        }
        catch (Exception e) {
            Logger.error((String)"==>     Failed: {}", (Object[])new Object[]{e.getMessage()});
            throw new InternalException("Failed to process pagination SQL: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.dialect != null) {
                this.dialect.afterAll();
            }
        }
    }

    private Future<Long> asyncCount(MappedStatement mappedStatement, BoundSql boundSql, Object parameter, RowBounds rowBounds) {
        Configuration configuration = mappedStatement.getConfiguration();
        BoundSql countBoundSql = new BoundSql(configuration, boundSql.getSql(), new ArrayList(boundSql.getParameterMappings()), parameter);
        Map<String, Object> additionalParameter = CountExecutor.getAdditionalParameter(boundSql);
        if (additionalParameter != null) {
            for (String key : additionalParameter.keySet()) {
                countBoundSql.setAdditionalParameter(key, additionalParameter.get(key));
            }
        }
        ManagedTransactionFactory transactionFactory = new ManagedTransactionFactory();
        Transaction tx = transactionFactory.newTransaction(configuration.getEnvironment().getDataSource(), null, false);
        Executor countExecutor = configuration.newExecutor(tx, configuration.getDefaultExecutorType());
        return this.dialect.asyncCountTask(() -> {
            Long l;
            try {
                l = this.count(countExecutor, mappedStatement, parameter, rowBounds, null, countBoundSql);
            }
            catch (Throwable throwable) {
                try {
                    tx.close();
                }
                catch (SQLException e) {
                    Logger.error((String)"Failed to close transaction: {}", (Object[])new Object[]{e.getMessage()});
                }
                throw throwable;
            }
            try {
                tx.close();
            }
            catch (SQLException e) {
                Logger.error((String)"Failed to close transaction: {}", (Object[])new Object[]{e.getMessage()});
            }
            return l;
        });
    }

    private Long count(Executor executor, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Long count;
        String countMsId = this.countMsId.genCountMsId(mappedStatement, parameter, boundSql, this.countSuffix);
        MappedStatement countMs = CountExecutor.getExistedMappedStatement(mappedStatement.getConfiguration(), countMsId);
        if (countMs != null) {
            count = CountExecutor.executeManualCount(executor, countMs, parameter, boundSql, resultHandler);
        } else {
            if (this.msCountMap != null) {
                countMs = (MappedStatement)this.msCountMap.read((Object)countMsId);
            }
            if (countMs == null) {
                countMs = CountMappedStatement.newCountMappedStatement(mappedStatement, countMsId);
                if (this.msCountMap != null) {
                    this.msCountMap.write((Object)countMsId, (Object)countMs, 60L);
                }
            }
            count = CountExecutor.executeAutoCount(this.dialect, executor, countMs, parameter, boundSql, rowBounds, resultHandler);
        }
        return count;
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object obj) {
    }

    public boolean setProperties(Properties properties) {
        this.msCountMap = CacheFactory.createCache(properties.getProperty("msCountCache"), "ms", properties);
        String dialectClass = properties.getProperty("dialect");
        if (StringKit.isEmpty((CharSequence)dialectClass)) {
            dialectClass = "org.miaixz.bus.pager.PageContext";
        }
        Dialect tempDialect = (Dialect)Builder.newInstance(dialectClass, properties);
        tempDialect.setProperties(properties);
        String countSuffix = properties.getProperty("countSuffix");
        if (StringKit.isNotEmpty((CharSequence)countSuffix)) {
            this.countSuffix = countSuffix;
        }
        this.debug = Boolean.parseBoolean(properties.getProperty("debug"));
        String countMsIdGenClass = properties.getProperty("countMsId");
        if (StringKit.isNotEmpty((CharSequence)countMsIdGenClass)) {
            this.countMsId = (CountMsId)Builder.newInstance(countMsIdGenClass, properties);
        }
        this.dialect = tempDialect;
        return true;
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

