/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.handler;

import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.mapper.handler.MapperBoundSql;
import org.miaixz.bus.mapper.handler.MapperHandler;
import org.miaixz.bus.mapper.handler.MapperStatementHandler;
import org.miaixz.bus.pager.handler.ConditionHandler;
import org.miaixz.bus.pager.handler.PermissionProvider;

public class PermissionHandler
extends ConditionHandler
implements MapperHandler {
    private PermissionProvider provider;

    public void prepare(StatementHandler statementHandler) {
        MapperStatementHandler mapperStatementHandler = PermissionHandler.mapperStatementHandler((StatementHandler)statementHandler);
        MappedStatement ms = mapperStatementHandler.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            MapperBoundSql mpBs = mapperStatementHandler.mapperBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), ms.getId()));
        }
    }

    public void query(Object result, Executor executor, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        MapperBoundSql mpBs = PermissionHandler.mapperBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), mappedStatement.getId()));
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Expression sqlSegment = this.getUpdateOrDeleteExpression(update.getTable(), update.getWhere(), (String)obj);
        if (null != sqlSegment) {
            update.setWhere(sqlSegment);
        }
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        Expression sqlSegment = this.getUpdateOrDeleteExpression(delete.getTable(), delete.getWhere(), (String)obj);
        if (null != sqlSegment) {
            delete.setWhere(sqlSegment);
        }
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object obj) {
        if (this.provider == null) {
            return;
        }
        if (this.provider instanceof PermissionProvider) {
            String whereSegment = (String)obj;
            this.processSelectBody(select, whereSegment);
            List withItemsList = select.getWithItemsList();
            if (!CollKit.isEmpty((Collection)withItemsList)) {
                withItemsList.forEach(withItem -> this.processSelectBody((Select)withItem.getSelect(), whereSegment));
            }
        }
    }

    @Override
    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getSqlSegment(table, where, whereSegment);
    }

    public PermissionProvider getProvider() {
        return this.provider;
    }

    public void setProvider(PermissionProvider provider) {
        this.provider = provider;
    }

    protected Expression getUpdateOrDeleteExpression(Table table, Expression where, String whereSegment) {
        if (this.provider == null) {
            return null;
        }
        return this.andExpression(table, where, whereSegment);
    }
}

