/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.handler;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.mapper.OGNL;
import org.miaixz.bus.mapper.handler.AbstractSqlHandler;

public class SqlParserHandler
extends AbstractSqlHandler {
    public static Statement parse(String sql) throws JSQLParserException {
        return CCJSqlParserUtil.parse((String)sql);
    }

    public static Statements parseStatements(String sql) throws JSQLParserException {
        return CCJSqlParserUtil.parseStatements((String)sql);
    }

    public String parserSingle(String sql, Object object) {
        try {
            Statement statement = SqlParserHandler.parse(sql);
            return this.processParser(statement, 0, sql, object);
        }
        catch (JSQLParserException e) {
            throw new InternalException("Failed to process, Error SQL: %s", sql);
        }
    }

    public String parserMulti(String sql, Object object) {
        try {
            StringBuilder sb = new StringBuilder();
            Statements statements = SqlParserHandler.parseStatements(sql);
            int i = 0;
            for (Statement statement : statements) {
                if (i > 0) {
                    sb.append(";");
                }
                sb.append(this.processParser(statement, i, sql, object));
                ++i;
            }
            return sb.toString();
        }
        catch (JSQLParserException e) {
            throw new InternalException("Failed to process, Error SQL: %s", sql);
        }
    }

    protected String processParser(Statement statement, int index, String sql, Object object) {
        if (statement instanceof Insert) {
            this.processInsert((Insert)statement, index, sql, object);
        } else if (statement instanceof Select) {
            this.processSelect((Select)statement, index, sql, object);
        } else if (statement instanceof Update) {
            this.processUpdate((Update)statement, index, sql, object);
        } else if (statement instanceof Delete) {
            this.processDelete((Delete)statement, index, sql, object);
        }
        return statement.toString();
    }

    protected void processInsert(Insert insert, int index, String sql, Object object) {
        throw new UnsupportedOperationException();
    }

    protected void processDelete(Delete delete, int index, String sql, Object object) {
        throw new UnsupportedOperationException();
    }

    protected void processUpdate(Update update, int index, String sql, Object object) {
        throw new UnsupportedOperationException();
    }

    protected void processSelect(Select select, int index, String sql, Object object) {
        throw new UnsupportedOperationException();
    }

    protected static void validateSql(String sql) {
        if (!"0".equals(sql) && !"*".equals(sql) && OGNL.validateSql((String)sql)) {
            throw new InternalException("SQL script validation failed: potential security issue detected, please review");
        }
    }
}

