/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.handler;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.miaixz.bus.core.Context;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.mapper.handler.MapperBoundSql;
import org.miaixz.bus.mapper.handler.MapperHandler;
import org.miaixz.bus.mapper.handler.MapperStatementHandler;
import org.miaixz.bus.pager.handler.ConditionHandler;
import org.miaixz.bus.pager.handler.TenantProvider;

public class TenantHandler
extends ConditionHandler
implements MapperHandler {
    private TenantProvider provider;

    public void query(Object object, Executor executor, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        MapperBoundSql mbs = TenantHandler.mapperBoundSql((BoundSql)boundSql);
        mbs.sql(this.parserSingle(mbs.sql(), null));
    }

    public void prepare(StatementHandler statementHandler) {
        MapperStatementHandler msh = TenantHandler.mapperStatementHandler((StatementHandler)statementHandler);
        MapperBoundSql mbs = msh.mapperBoundSql();
        mbs.sql(this.parserMulti(mbs.sql(), null));
    }

    @Override
    protected void processSelect(Select select, int index, String sql, Object object) {
        String whereSegment = (String)object;
        this.processSelectBody(select, whereSegment);
        List withItemsList = select.getWithItemsList();
        if (!CollKit.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(withItem -> this.processSelectBody((Select)withItem.getSelect(), whereSegment));
        }
    }

    @Override
    protected void processInsert(Insert insert, int index, String sql, Object object) {
        Select select;
        if (this.provider.ignore(insert.getTable().getName())) {
            return;
        }
        ExpressionList columns = insert.getColumns();
        if (CollKit.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.provider.getColumn();
        if (this.provider.ignore((List<Column>)columns, tenantIdColumn)) {
            return;
        }
        columns.add(new Column(tenantIdColumn));
        Expression tenantId = this.provider.getTenantId();
        List duplicateUpdateColumns = insert.getDuplicateUpdateSets();
        if (CollKit.isNotEmpty((Collection)duplicateUpdateColumns)) {
            duplicateUpdateColumns.add(new UpdateSet(new Column(tenantIdColumn), tenantId));
        }
        if ((select = insert.getSelect()) instanceof PlainSelect) {
            this.processInsertSelect(select, (String)object);
        } else if (insert.getValues() != null) {
            Values values = insert.getValues();
            ExpressionList expressions = values.getExpressions();
            if (expressions instanceof ParenthesedExpressionList) {
                expressions.addExpression(tenantId);
            } else if (CollKit.isNotEmpty((Collection)expressions)) {
                for (Expression expression : expressions) {
                    if (expression instanceof ParenthesedExpressionList) {
                        ((ParenthesedExpressionList)expression).addExpression(tenantId);
                        continue;
                    }
                    expressions.add((Object)tenantId);
                }
            } else {
                expressions.add((Object)tenantId);
            }
        } else {
            throw new InternalException("Failed to process multiple-table update, please exclude the tableName or statementId");
        }
    }

    @Override
    protected void processUpdate(Update update, int index, String sql, Object object) {
        Table table = update.getTable();
        if (this.provider.ignore(table.getName())) {
            return;
        }
        List sets = update.getUpdateSets();
        if (!CollKit.isEmpty((Collection)sets)) {
            sets.forEach(us -> us.getValues().forEach(ex -> {
                if (ex instanceof Select) {
                    this.processSelectBody((Select)ex, (String)object);
                }
            }));
        }
        update.setWhere(this.andExpression(table, update.getWhere(), (String)object));
    }

    @Override
    protected void processDelete(Delete delete, int index, String sql, Object object) {
        if (this.provider.ignore(delete.getTable().getName())) {
            return;
        }
        delete.setWhere(this.andExpression(delete.getTable(), delete.getWhere(), (String)object));
    }

    protected void processInsertSelect(Select select, String segment) {
        if (select instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)select;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem instanceof Table) {
                this.processPlainSelect(plainSelect, segment);
                this.appendSelectItem(plainSelect.getSelectItems());
            } else if (fromItem instanceof Select) {
                Select subSelect = (Select)fromItem;
                this.appendSelectItem(plainSelect.getSelectItems());
                this.processInsertSelect(subSelect, segment);
            }
        } else if (select instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)select;
            this.processInsertSelect(parenthesedSelect.getSelect(), segment);
        }
    }

    protected void appendSelectItem(List<SelectItem<?>> selectItems) {
        SelectItem<?> item;
        Expression expression;
        if (CollKit.isEmpty(selectItems)) {
            return;
        }
        if (selectItems.size() == 1 && (expression = (item = selectItems.get(0)).getExpression()) instanceof AllColumns) {
            return;
        }
        selectItems.add(new SelectItem((Expression)new Column(this.provider.getColumn())));
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName()).append(".");
        }
        column.append(this.provider.getColumn());
        return new Column(column.toString());
    }

    public boolean setProperties(Properties properties) {
        Context.newInstance((Properties)properties).whenNotBlank("provider", ReflectKit::newInstance, this::setProvider);
        return true;
    }

    @Override
    public Expression buildTableExpression(Table table, Expression where, String segment) {
        if (this.provider.ignore(table.getName())) {
            return null;
        }
        return new EqualsTo((Expression)this.getAliasColumn(table), this.provider.getTenantId());
    }

    public TenantProvider getProvider() {
        return this.provider;
    }

    public void setProvider(TenantProvider provider) {
        this.provider = provider;
    }
}

