/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.pager.parsing;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.miaixz.bus.pager.Builder;
import org.miaixz.bus.pager.binding.PageMethod;
import org.miaixz.bus.pager.parsing.CountSqlParser;

public class DefaultCountSqlParser
implements CountSqlParser {
    public static final String KEEP_ORDERBY = "/*keep orderby*/";
    protected static final Alias TABLE_ALIAS = new Alias("table_count");
    private final Set<String> skipFunctions = Collections.synchronizedSet(new HashSet());
    private final Set<String> falseFunctions = Collections.synchronizedSet(new HashSet());

    @Override
    public String getSmartCountSql(String sql, String countColumn) {
        if (sql.contains(KEEP_ORDERBY) || this.keepOrderBy()) {
            return this.getSimpleCountSql(sql, countColumn);
        }
        try {
            String hints;
            Token token;
            Statement stmt = Builder.parse(sql);
            Select select = (Select)stmt;
            this.processSelect(select);
            this.processWithItemsList(select.getWithItemsList());
            Select countSelect = this.sqlToCount(select, countColumn);
            Object result = countSelect.toString();
            if (select instanceof PlainSelect && select.getASTNode() != null && (token = select.getASTNode().jjtGetFirstToken()) != null && token.specialToken != null && (hints = token.specialToken.toString().trim()).startsWith("/*") && hints.endsWith("*/") && !((String)result).startsWith("/*")) {
                result = hints + " " + (String)result;
            }
            return result;
        }
        catch (Throwable e) {
            return this.getSimpleCountSql(sql, countColumn);
        }
    }

    public String getSimpleCountSql(String sql) {
        return this.getSimpleCountSql(sql, "0");
    }

    public String getSimpleCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 50);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from ( \n");
        stringBuilder.append(sql);
        stringBuilder.append("\n ) tmp_count");
        return stringBuilder.toString();
    }

    public Select sqlToCount(Select select, String name) {
        List<SelectItem> countItem = Collections.singletonList(new SelectItem((Expression)new Column("COUNT(" + name + ")")));
        if (select instanceof PlainSelect && this.isSimpleCount((PlainSelect)select)) {
            ((PlainSelect)select).setSelectItems(countItem);
            return select;
        }
        PlainSelect plainSelect = new PlainSelect();
        ParenthesedSelect subSelect = new ParenthesedSelect();
        subSelect.setSelect(select);
        subSelect.setAlias(TABLE_ALIAS);
        plainSelect.setFromItem((FromItem)subSelect);
        plainSelect.setSelectItems(countItem);
        if (select.getWithItemsList() != null) {
            plainSelect.setWithItemsList(select.getWithItemsList());
            select.setWithItemsList(null);
        }
        return plainSelect;
    }

    public boolean isSimpleCount(PlainSelect select) {
        if (select.getGroupBy() != null || select.getDistinct() != null || select.getHaving() != null) {
            return false;
        }
        for (SelectItem item : select.getSelectItems()) {
            String itemStr = item.toString();
            if (itemStr.contains("?")) {
                return false;
            }
            Expression expression = item.getExpression();
            if (expression instanceof Function) {
                String upperName;
                String name = ((Function)expression).getName();
                if (name == null || this.skipFunctions.contains(upperName = name.toUpperCase())) continue;
                if (this.falseFunctions.contains(upperName)) {
                    return false;
                }
                for (String aggFunc : AGGREGATE_FUNCTIONS) {
                    if (!upperName.startsWith(aggFunc)) continue;
                    this.falseFunctions.add(upperName);
                    return false;
                }
                this.skipFunctions.add(upperName);
                continue;
            }
            if (expression instanceof ParenthesedExpressionList && item.getAlias() != null) {
                return false;
            }
            if (item.getAlias() == null || !expression.toString().startsWith("(") || !expression.toString().endsWith(")")) continue;
            return false;
        }
        return true;
    }

    public void processSelect(Select select) {
        if (select == null) {
            return;
        }
        if (select instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)select);
        } else if (select instanceof ParenthesedSelect) {
            this.processSelect(((ParenthesedSelect)select).getSelect());
        } else if (select instanceof SetOperationList) {
            SetOperationList setOpList = (SetOperationList)select;
            for (Select sel : setOpList.getSelects()) {
                this.processSelect(sel);
            }
            if (!this.orderByHashParameters(setOpList.getOrderByElements())) {
                setOpList.setOrderByElements(null);
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        List joins;
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if ((joins = plainSelect.getJoins()) != null) {
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processWithItemsList(List<WithItem<?>> withItemsList) {
        if (withItemsList == null || withItemsList.isEmpty() || this.keepSubSelectOrderBy()) {
            return;
        }
        for (WithItem<?> item : withItemsList) {
            ParenthesedSelect select = item.getSelect();
            if (select == null) continue;
            this.processSelect((Select)select);
        }
    }

    public void processFromItem(FromItem fromItem) {
        if (fromItem instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
            Select select = parenthesedSelect.getSelect();
            if (select != null && !this.keepSubSelectOrderBy()) {
                this.processSelect(select);
            }
        } else if (fromItem instanceof Select) {
            this.processSelect((Select)fromItem);
        } else if (fromItem instanceof ParenthesedFromItem) {
            this.processFromItem(((ParenthesedFromItem)fromItem).getFromItem());
        }
    }

    protected boolean keepOrderBy() {
        return PageMethod.getLocalPage() != null && PageMethod.getLocalPage().keepOrderBy();
    }

    protected boolean keepSubSelectOrderBy() {
        return PageMethod.getLocalPage() != null && PageMethod.getLocalPage().keepSubSelectOrderBy();
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null || orderByElements.isEmpty()) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }

    static {
        TABLE_ALIAS.setUseAs(false);
    }
}

