/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.proxy.Factory;
import org.miaixz.bus.proxy.aspects.Aspectj;
import org.miaixz.bus.proxy.factory.AbstractFactory;
import org.miaixz.bus.proxy.invoker.NullInvoker;

public class Builder {
    public static final Object[] EMPTY_ARGUMENTS = Normal.EMPTY_OBJECT_ARRAY;
    public static final Class[] EMPTY_ARGUMENT_TYPES = Normal.EMPTY_CLASS_ARRAY;
    private static final Map wrapperClassMap = new HashMap();

    public static Object createNullObject(Factory factory, Class[] proxyClasses) {
        return factory.createInvokerProxy(new NullInvoker(), proxyClasses);
    }

    public static Object createNullObject(Factory factory, ClassLoader classLoader, Class[] proxyClasses) {
        return factory.createInvokerProxy(classLoader, new NullInvoker(), proxyClasses);
    }

    public static Class[] getAllInterfaces(Class cls) {
        List interfaces = Builder.getAllInterfacesImpl(cls, new LinkedList());
        return null == interfaces ? null : interfaces.toArray(new Class[interfaces.size()]);
    }

    private static List getAllInterfacesImpl(Class cls, List list) {
        if (null == cls) {
            return null;
        }
        while (null != cls) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!list.contains(interfaces[i])) {
                    list.add(interfaces[i]);
                }
                Builder.getAllInterfacesImpl(interfaces[i], list);
            }
            cls = cls.getSuperclass();
        }
        return list;
    }

    public static String getJavaClassName(Class clazz) {
        if (clazz.isArray()) {
            return Builder.getJavaClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static Class getWrapperClass(Class primitiveType) {
        return (Class)wrapperClassMap.get(primitiveType);
    }

    public static <T> T proxy(T target, Class<? extends Aspectj> aspectClass) {
        return AbstractFactory.createProxy(target, aspectClass);
    }

    public static <T> T proxy(T target, Aspectj aspectj) {
        return AbstractFactory.createProxy(target, aspectj);
    }

    public static <T> T newProxyInstance(ClassLoader classloader, InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(classloader, interfaces, invocationHandler);
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return Builder.newProxyInstance(ClassKit.getClassLoader(), invocationHandler, interfaces);
    }

    static {
        wrapperClassMap.put(Integer.TYPE, Integer.class);
        wrapperClassMap.put(Character.TYPE, Character.class);
        wrapperClassMap.put(Boolean.TYPE, Boolean.class);
        wrapperClassMap.put(Short.TYPE, Short.class);
        wrapperClassMap.put(Long.TYPE, Long.class);
        wrapperClassMap.put(Float.TYPE, Float.class);
        wrapperClassMap.put(Double.TYPE, Double.class);
        wrapperClassMap.put(Byte.TYPE, Byte.class);
    }
}

