/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.miaixz.bus.proxy.Builder;
import org.miaixz.bus.proxy.Interceptor;
import org.miaixz.bus.proxy.Invocation;
import org.miaixz.bus.proxy.Invoker;
import org.miaixz.bus.proxy.Provider;

public class Factory {
    public boolean canProxy(Class[] proxyClasses) {
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyClass = proxyClasses[i];
            if (proxyClass.isInterface()) continue;
            return false;
        }
        return true;
    }

    public Object createDelegatorProxy(Provider delegateProvider, Class[] proxyClasses) {
        return this.createDelegatorProxy(Thread.currentThread().getContextClassLoader(), delegateProvider, proxyClasses);
    }

    public Object createDelegatorProxy(ClassLoader classLoader, Provider delegateProvider, Class[] proxyClasses) {
        return Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new DelegatorInvocationHandler(delegateProvider));
    }

    public Object createInterceptorProxy(Object target, Interceptor interceptor, Class[] proxyClasses) {
        return this.createInterceptorProxy(Thread.currentThread().getContextClassLoader(), target, interceptor, proxyClasses);
    }

    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        return Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new InterceptorInvocationHandler(target, interceptor));
    }

    public Object createInvokerProxy(Invoker invoker, Class[] proxyClasses) {
        return this.createInvokerProxy(Thread.currentThread().getContextClassLoader(), invoker, proxyClasses);
    }

    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        return Proxy.newProxyInstance(classLoader, proxyClasses, (InvocationHandler)new InvokerInvocationHandler(invoker));
    }

    private static class DelegatorInvocationHandler
    implements InvocationHandler {
        private final Provider delegateProvider;

        protected DelegatorInvocationHandler(Provider delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegateProvider.getObject(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    private static class InterceptorInvocationHandler
    implements InvocationHandler {
        private final Object target;
        private final Interceptor methodInterceptor;

        public InterceptorInvocationHandler(Object target, Interceptor methodInterceptor) {
            this.target = target;
            this.methodInterceptor = methodInterceptor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ReflectionInvocation invocation = new ReflectionInvocation(this.target, method, args);
            return this.methodInterceptor.intercept(invocation);
        }
    }

    private static class InvokerInvocationHandler
    implements InvocationHandler {
        private final Invoker invoker;

        public InvokerInvocationHandler(Invoker invoker) {
            this.invoker = invoker;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.invoker.invoke(proxy, method, args);
        }
    }

    private static class ReflectionInvocation
    implements Invocation {
        private final Method method;
        private final Object[] arguments;
        private final Object target;

        public ReflectionInvocation(Object target, Method method, Object[] arguments) {
            this.method = method;
            this.arguments = null == arguments ? Builder.EMPTY_ARGUMENTS : arguments;
            this.target = target;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object getProxy() {
            return this.target;
        }

        @Override
        public Object proceed() throws Throwable {
            try {
                return this.method.invoke(this.target, this.arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

