/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy.factory.cglib;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.miaixz.bus.proxy.Interceptor;
import org.miaixz.bus.proxy.Invocation;
import org.miaixz.bus.proxy.Invoker;
import org.miaixz.bus.proxy.Provider;
import org.miaixz.bus.proxy.aspects.Aspectj;
import org.miaixz.bus.proxy.factory.AbstractFactory;
import org.miaixz.bus.proxy.intercept.CglibInterceptor;

public class CglibFactory
extends AbstractFactory {
    private static CallbackFilter callbackFilter = new PublicCallbackFilter();

    @Override
    public <T> T proxy(T target, Aspectj aspectj) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallback((Callback)new CglibInterceptor(target, aspectj));
        return (T)enhancer.create();
    }

    @Override
    public Object createDelegatorProxy(ClassLoader classLoader, Provider targetProvider, Class[] proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces(CglibFactory.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibFactory.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(new Callback[]{new ObjectProviderDispatcher(this, targetProvider), NoOp.INSTANCE});
        return enhancer.create();
    }

    @Override
    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces(CglibFactory.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibFactory.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(new Callback[]{new InterceptorBridge(target, interceptor), NoOp.INSTANCE});
        return enhancer.create();
    }

    @Override
    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces(CglibFactory.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibFactory.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(new Callback[]{new InvokerBridge(this, invoker), NoOp.INSTANCE});
        return enhancer.create();
    }

    private class ObjectProviderDispatcher
    implements Dispatcher {
        private final Provider delegateProvider;

        public ObjectProviderDispatcher(CglibFactory cglibFactory, Provider delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        public Object loadObject() {
            return this.delegateProvider.getObject();
        }
    }

    private class InterceptorBridge
    implements MethodInterceptor {
        private final Interceptor inner;
        private final Object target;

        public InterceptorBridge(Object target, Interceptor inner) {
            this.inner = inner;
            this.target = target;
        }

        public Object intercept(Object object, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return this.inner.intercept(new MethodProxyInvocation(CglibFactory.this, this.target, method, args, methodProxy));
        }
    }

    private class InvokerBridge
    implements InvocationHandler {
        private final Invoker original;

        public InvokerBridge(CglibFactory cglibFactory, Invoker original) {
            this.original = original;
        }

        public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
            return this.original.invoke(object, method, objects);
        }
    }

    private static class PublicCallbackFilter
    implements CallbackFilter {
        private PublicCallbackFilter() {
        }

        public int accept(Method method) {
            return Modifier.isPublic(method.getModifiers()) ? 0 : 1;
        }
    }

    private class MethodProxyInvocation
    implements Invocation {
        private final MethodProxy methodProxy;
        private final Method method;
        private final Object[] args;
        private final Object target;

        public MethodProxyInvocation(CglibFactory cglibFactory, Object target, Method method, Object[] args, MethodProxy methodProxy) {
            this.target = target;
            this.method = method;
            this.methodProxy = methodProxy;
            this.args = args;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object[] getArguments() {
            return this.args;
        }

        @Override
        public Object proceed() throws Throwable {
            return this.methodProxy.invoke(this.target, this.args);
        }

        @Override
        public Object getProxy() {
            return this.target;
        }
    }
}

