/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy.factory.javassist;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.proxy.Interceptor;
import org.miaixz.bus.proxy.Invoker;
import org.miaixz.bus.proxy.Provider;
import org.miaixz.bus.proxy.aspects.Aspectj;
import org.miaixz.bus.proxy.factory.AbstractFactory;
import org.miaixz.bus.proxy.factory.AbstractProxyClass;
import org.miaixz.bus.proxy.factory.ProxyClassCache;
import org.miaixz.bus.proxy.factory.javassist.JavassistInvocation;
import org.miaixz.bus.proxy.factory.javassist.JavassistKit;
import org.miaixz.bus.proxy.intercept.JavassistInterceptor;

public class JavassistFactory
extends AbstractFactory {
    private static final ProxyClassCache delegatingProxyClassCache = new ProxyClassCache(new DelegatingProxyClassGenerator());
    private static final ProxyClassCache interceptorProxyClassCache = new ProxyClassCache(new InterceptorProxyClassGenerator());
    private static final ProxyClassCache invocationHandlerProxyClassCache = new ProxyClassCache(new InvokerProxyClassGenerator());

    @Override
    public <T> T proxy(T target, Aspectj aspectj) {
        return JavassistFactory.newProxyInstance(target.getClass().getClassLoader(), new JavassistInterceptor(target, aspectj), target.getClass().getInterfaces());
    }

    @Override
    public Object createDelegatorProxy(ClassLoader classLoader, Provider targetProvider, Class[] proxyClasses) {
        try {
            Class clazz = delegatingProxyClassCache.getProxyClass(classLoader, proxyClasses);
            return clazz.getConstructor(Provider.class).newInstance(targetProvider);
        }
        catch (Exception e) {
            throw new InternalException("Unable to instantiate proxy from generated proxy class.", (Throwable)e);
        }
    }

    @Override
    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        try {
            Class clazz = interceptorProxyClassCache.getProxyClass(classLoader, proxyClasses);
            Method[] methods = AbstractProxyClass.getImplementationMethods(proxyClasses);
            return clazz.getConstructor(Method[].class, Object.class, Interceptor.class).newInstance(methods, target, interceptor);
        }
        catch (Exception e) {
            throw new InternalException("Unable to instantiate proxy class instance.", (Throwable)e);
        }
    }

    @Override
    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        try {
            Class clazz = invocationHandlerProxyClassCache.getProxyClass(classLoader, proxyClasses);
            Method[] methods = AbstractProxyClass.getImplementationMethods(proxyClasses);
            return clazz.getConstructor(Method[].class, Invoker.class).newInstance(methods, invoker);
        }
        catch (Exception e) {
            throw new InternalException("Unable to instantiate proxy from generated proxy class.", (Throwable)e);
        }
    }

    private static class DelegatingProxyClassGenerator
    extends AbstractProxyClass {
        private DelegatingProxyClassGenerator() {
        }

        @Override
        public Class createProxy(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistKit.createClass(AbstractFactory.getSuperclass(proxyClasses));
                JavassistKit.addField(Provider.class, "provider", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistKit.resolve(new Class[]{Provider.class}), proxyClass);
                proxyConstructor.setBody("{ this.provider = $1; }");
                proxyClass.addConstructor(proxyConstructor);
                JavassistKit.addInterfaces(proxyClass, JavassistFactory.toInterfaces(proxyClasses));
                Method[] methods = DelegatingProxyClassGenerator.getImplementationMethods(proxyClasses);
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    CtMethod ctMethod = new CtMethod(JavassistKit.resolve(method.getReturnType()), method.getName(), JavassistKit.resolve(method.getParameterTypes()), proxyClass);
                    String body = "{ return ( $r ) ( ( " + method.getDeclaringClass().getName() + " )provider.getObject() )." + method.getName() + "($$); }";
                    ctMethod.setBody(body);
                    proxyClass.addMethod(ctMethod);
                }
                return proxyClass.toClass(classLoader, null);
            }
            catch (CannotCompileException e) {
                throw new InternalException("Could not compile class.", (Throwable)e);
            }
        }
    }

    private static class InterceptorProxyClassGenerator
    extends AbstractProxyClass {
        private InterceptorProxyClassGenerator() {
        }

        @Override
        public Class createProxy(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistKit.createClass(AbstractFactory.getSuperclass(proxyClasses));
                Method[] methods = InterceptorProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistKit.addInterfaces(proxyClass, JavassistFactory.toInterfaces(proxyClasses));
                JavassistKit.addField(Method[].class, "methods", proxyClass);
                JavassistKit.addField(Object.class, "target", proxyClass);
                JavassistKit.addField(Interceptor.class, "intercept", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistKit.resolve(new Class[]{Method[].class, Object.class, Interceptor.class}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.methods = $1;\n\tthis.target = $2;\n\tthis.intercept = $3; }");
                proxyClass.addConstructor(proxyConstructor);
                for (int i = 0; i < methods.length; ++i) {
                    CtMethod method = new CtMethod(JavassistKit.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistKit.resolve(methods[i].getParameterTypes()), proxyClass);
                    Class invocationClass = JavassistInvocation.getMethodInvocationClass(classLoader, methods[i]);
                    String body = "{\n\t return ( $r ) intercept.intercept( new " + invocationClass.getName() + "( methods[" + i + "], target, $args ) );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader, null);
            }
            catch (CannotCompileException e) {
                throw new InternalException("Could not compile class.", (Throwable)e);
            }
        }
    }

    private static class InvokerProxyClassGenerator
    extends AbstractProxyClass {
        private InvokerProxyClassGenerator() {
        }

        @Override
        public Class createProxy(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistKit.createClass(AbstractFactory.getSuperclass(proxyClasses));
                Method[] methods = InvokerProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistKit.addInterfaces(proxyClass, JavassistFactory.toInterfaces(proxyClasses));
                JavassistKit.addField(Method[].class, "methods", proxyClass);
                JavassistKit.addField(Invoker.class, "invoker", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistKit.resolve(new Class[]{Method[].class, Invoker.class}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.methods = $1;\n\tthis.invoker = $2; }");
                proxyClass.addConstructor(proxyConstructor);
                for (int i = 0; i < methods.length; ++i) {
                    CtMethod method = new CtMethod(JavassistKit.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistKit.resolve(methods[i].getParameterTypes()), proxyClass);
                    String body = "{\n\t return ( $r ) invoker.invoke( this, methods[" + i + "], $args );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader, null);
            }
            catch (CannotCompileException e) {
                throw new InternalException("Could not compile class.", (Throwable)e);
            }
        }
    }
}

