/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy.intercept;

import org.miaixz.bus.proxy.Builder;
import org.miaixz.bus.proxy.Factory;
import org.miaixz.bus.proxy.Interceptor;
import org.miaixz.bus.proxy.Provider;

public class InterceptorChain {
    private final Interceptor[] interceptors;

    public InterceptorChain(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    private Object createProxy(Factory factory, ClassLoader classLoader, Object terminus, Class[] proxyClasses) {
        Object currentTarget = terminus;
        for (int i = this.interceptors.length - 1; i >= 0; --i) {
            currentTarget = factory.createInterceptorProxy(classLoader, currentTarget, this.interceptors[i], proxyClasses);
        }
        return currentTarget;
    }

    public Provider createProxyProvider(Factory factory, Object object) {
        return this.createProxyProvider(factory, object, null);
    }

    public Provider createProxyProvider(Factory factory, Object object, Class[] proxyClasses) {
        return this.createProxyProvider(factory, Thread.currentThread().getContextClassLoader(), object, proxyClasses);
    }

    public Provider createProxyProvider(Factory factory, ClassLoader classLoader, Object object, Class[] proxyClasses) {
        if (null == proxyClasses || proxyClasses.length == 0) {
            proxyClasses = Builder.getAllInterfaces(object.getClass());
        }
        return new ProxyProvider(factory, classLoader, object, proxyClasses);
    }

    private class ProxyProvider
    implements Provider {
        private final ClassLoader classLoader;
        private final Class[] proxyClasses;
        private final Object terminus;
        private final Factory factory;

        public ProxyProvider(Factory factory, ClassLoader classLoader, Object terminus, Class[] proxyClasses) {
            this.classLoader = classLoader;
            this.proxyClasses = proxyClasses;
            this.terminus = terminus;
            this.factory = factory;
        }

        @Override
        public Object getObject() {
            return InterceptorChain.this.createProxy(this.factory, this.classLoader, this.terminus, this.proxyClasses);
        }
    }
}

