/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy.provider;

import java.lang.reflect.InvocationTargetException;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.proxy.Provider;

public class BeanProvider
implements Provider {
    private Class beanClass;

    public BeanProvider() {
    }

    public BeanProvider(Class beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Object getObject() {
        try {
            if (null == this.beanClass) {
                throw new InternalException("No bean class provided.");
            }
            return this.beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new InternalException("Class " + this.beanClass.getName() + " is not concrete.", (Throwable)e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalException("Constructor for class " + this.beanClass.getName() + " is not accessible.", (Throwable)e);
        }
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }
}

