/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy.spring;

import java.lang.reflect.Constructor;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.proxy.Aspect;
import org.miaixz.bus.proxy.Provider;
import org.miaixz.bus.proxy.spring.SpringCglibInterceptor;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;

public class SpringCglibProvider
implements Provider {
    private static <T> T create(Enhancer enhancer, Class<?> targetClass) {
        Constructor[] constructors = ReflectKit.getConstructors(targetClass);
        IllegalArgumentException finalException = null;
        for (Constructor constructor : constructors) {
            Class[] parameterTypes = constructor.getParameterTypes();
            Object[] values = ClassKit.getDefaultValues((Class[])parameterTypes);
            try {
                return (T)enhancer.create(parameterTypes, values);
            }
            catch (IllegalArgumentException e) {
                finalException = e;
            }
        }
        if (null != finalException) {
            throw finalException;
        }
        throw new IllegalArgumentException("No constructor provided");
    }

    @Override
    public <T> T proxy(T target, Aspect aspect) {
        Class<?> targetClass = target.getClass();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(targetClass);
        enhancer.setCallback((Callback)new SpringCglibInterceptor(target, aspect));
        return SpringCglibProvider.create(enhancer, targetClass);
    }
}

