/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.proxy.Aspect;
import org.miaixz.bus.proxy.Factory;
import org.miaixz.bus.proxy.Provider;

public final class Builder {
    public static Provider getEngine() {
        return Factory.getEngine();
    }

    public static <T> T proxy(T target, Class<? extends Aspect> aspectClass) {
        return Builder.getEngine().proxy(target, aspectClass);
    }

    public static <T> T proxy(T target, Aspect aspect) {
        return Builder.getEngine().proxy(target, aspect);
    }

    public static <T> T newProxyInstance(ClassLoader classloader, InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(classloader, interfaces, invocationHandler);
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return Builder.newProxyInstance(ClassKit.getClassLoader(), invocationHandler, interfaces);
    }

    public static boolean isProxy(Object object) {
        return Builder.isJdkProxy(object) || Builder.isCglibProxy(object);
    }

    public static boolean isJdkProxy(Object object) {
        return Proxy.isProxyClass(object.getClass());
    }

    public static boolean isCglibProxy(Object object) {
        return object.getClass().getName().contains("$$");
    }
}

