/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.sensitive;

import com.alibaba.fastjson.serializer.BeanContext;
import com.alibaba.fastjson.serializer.ContextValueFilter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.TypeKit;
import org.miaixz.bus.sensitive.Context;
import org.miaixz.bus.sensitive.Registry;
import org.miaixz.bus.sensitive.magic.annotation.Condition;
import org.miaixz.bus.sensitive.magic.annotation.Entry;
import org.miaixz.bus.sensitive.magic.annotation.Shield;
import org.miaixz.bus.sensitive.metric.ConditionProvider;
import org.miaixz.bus.sensitive.metric.StrategyProvider;

public class Filter
implements ContextValueFilter {
    private final Context sensitiveContext;

    public Filter(Context context) {
        this.sensitiveContext = context;
    }

    private static ConditionProvider getConditionOpt(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Condition sensitiveCondition = annotation.annotationType().getAnnotation(Condition.class);
            if (!ObjectKit.isNotNull((Object)sensitiveCondition)) continue;
            return (ConditionProvider)ReflectKit.newInstance(sensitiveCondition.value(), (Object[])new Object[0]);
        }
        return null;
    }

    public Object process(BeanContext context, Object object, String name, Object value) {
        Object firstCollectionEntry;
        Collection entryCollection;
        Object firstArrayEntry;
        Class<?> entryFieldClass;
        Object[] arrays;
        if (ObjectKit.isNull((Object)context)) {
            return value;
        }
        Field field = context.getField();
        Class clazz = context.getBeanClass();
        ArrayList fieldList = ListKit.of((Object[])FieldKit.getFields((Class)clazz));
        this.sensitiveContext.setCurrentField(field);
        this.sensitiveContext.setCurrentObject(object);
        this.sensitiveContext.setBeanClass(clazz);
        this.sensitiveContext.setAllFieldList(fieldList);
        Entry sensitiveEntry = field.getAnnotation(Entry.class);
        if (ObjectKit.isNull((Object)sensitiveEntry)) {
            this.sensitiveContext.setEntry(value);
            return this.handleSensitive(this.sensitiveContext, field);
        }
        Class<?> fieldTypeClass = field.getType();
        if (TypeKit.isJavaBean(fieldTypeClass)) {
            return value;
        }
        if (TypeKit.isMap(fieldTypeClass)) {
            return value;
        }
        if (TypeKit.isArray(fieldTypeClass) && ArrayKit.isNotEmpty((Object[])(arrays = (Object[])value)) && this.isBaseType(entryFieldClass = (firstArrayEntry = ArrayKit.firstNonNull((Object[])arrays)).getClass())) {
            int arrayLength = arrays.length;
            Object newArray = Array.newInstance(entryFieldClass, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object entry = arrays[i];
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                Array.set(newArray, i, result);
            }
            return newArray;
        }
        if (TypeKit.isCollection(fieldTypeClass) && CollKit.isNotEmpty((Collection)(entryCollection = (Collection)value)) && this.isBaseType((firstCollectionEntry = ArrayKit.firstNonNull((Object[])new Collection[]{entryCollection})).getClass())) {
            ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
            for (Object entry : entryCollection) {
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                newResultList.add(result);
            }
            return newResultList;
        }
        return value;
    }

    private Object handleSensitive(Context context, Field field) {
        try {
            StrategyProvider strategyProvider;
            ConditionProvider conditionOptional;
            Class<? extends ConditionProvider> conditionClass;
            ConditionProvider condition;
            Object originalFieldVal = context.getEntry();
            Shield sensitive = field.getAnnotation(Shield.class);
            if (ObjectKit.isNotNull((Object)sensitive) && (condition = (conditionClass = sensitive.condition()).getConstructor(new Class[0]).newInstance(new Object[0])).valid(context)) {
                StrategyProvider strategy = Registry.require(sensitive.type());
                if (ObjectKit.isEmpty((Object)strategy)) {
                    Class<? extends StrategyProvider> strategyClass = sensitive.strategy();
                    strategy = strategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.sensitiveContext.setEntry(null);
                return strategy.build(originalFieldVal, context);
            }
            Object[] annotations = field.getAnnotations();
            if (ArrayKit.isNotEmpty((Object[])annotations) && ObjectKit.isNotEmpty((Object)(conditionOptional = Filter.getConditionOpt((Annotation[])annotations))) && ObjectKit.isEmpty((Object)(strategyProvider = Registry.require((Annotation[])annotations)))) {
                this.sensitiveContext.setEntry(null);
                return strategyProvider.build(originalFieldVal, context);
            }
            this.sensitiveContext.setEntry(null);
            return originalFieldVal;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private boolean isBaseType(Class fieldTypeClass) {
        if (TypeKit.isBase((Class)fieldTypeClass)) {
            return true;
        }
        return !TypeKit.isJavaBean((Class)fieldTypeClass) && !TypeKit.isArray((Class)fieldTypeClass) && !TypeKit.isCollection((Class)fieldTypeClass) && !TypeKit.isMap((Class)fieldTypeClass);
    }
}

