/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.sensitive.metric;

import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.sensitive.Builder;
import org.miaixz.bus.sensitive.metric.StrategyProvider;

public abstract class AbstractProvider
implements StrategyProvider {
    public static String build(Builder.Mode mode, String rawVal, String shadow) {
        StringBuilder resultBuilder = new StringBuilder();
        int length = rawVal.length();
        if (mode == Builder.Mode.TAIL || mode == Builder.Mode.HEAD) {
            boolean head;
            int half = (int)Math.ceil((double)length / 2.0);
            boolean bl = head = mode == Builder.Mode.HEAD;
            if (head) {
                resultBuilder.append(StringKit.repeat((CharSequence)shadow, (int)half)).append(rawVal, half, length);
            } else {
                resultBuilder.append(rawVal, 0, length - half).append(StringKit.repeat((CharSequence)shadow, (int)half));
            }
            return resultBuilder.toString();
        }
        if (length == 2) {
            return resultBuilder.append(rawVal, 0, 1).append(shadow).toString();
        }
        int middle = Math.max((int)Math.ceil((double)length / 2.0), 1);
        int side = Math.max((int)Math.floor((double)(length - middle) / 2.0), 1);
        middle = length - side * 2;
        resultBuilder.append(rawVal, 0, side).append(StringKit.repeat((CharSequence)shadow, (int)middle)).append(rawVal, side + middle, length);
        return resultBuilder.toString();
    }

    public static String build(Builder.Mode mode, int fixedHeaderSize, int fixedTailorSize, String rawVal, String shadow) {
        StringBuilder resultBuilder = new StringBuilder();
        int length = rawVal.length();
        switch (mode) {
            case TAIL: {
                if (length <= fixedHeaderSize) {
                    return rawVal;
                }
                int maskLength = length - fixedHeaderSize;
                resultBuilder.append(rawVal, 0, fixedHeaderSize).append(StringKit.repeat((CharSequence)shadow, (int)maskLength));
                break;
            }
            default: {
                if (length <= fixedTailorSize) {
                    return rawVal;
                }
                int maskLength = length - fixedTailorSize;
                resultBuilder.append(StringKit.repeat((CharSequence)shadow, (int)maskLength)).append(rawVal.substring(maskLength));
                break;
            }
            case MIDDLE: {
                int unmaskLength = fixedTailorSize + fixedHeaderSize;
                if (length <= unmaskLength) {
                    return rawVal;
                }
                int maskLength = length - unmaskLength;
                resultBuilder.append(rawVal, 0, fixedHeaderSize).append(StringKit.repeat((CharSequence)shadow, (int)maskLength)).append(rawVal, fixedHeaderSize + maskLength, length);
            }
        }
        return resultBuilder.toString();
    }
}

