/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.sensitive;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.sensitive.Builder;
import org.miaixz.bus.sensitive.magic.annotation.Strategy;
import org.miaixz.bus.sensitive.metric.AddressProvider;
import org.miaixz.bus.sensitive.metric.BandCardProvider;
import org.miaixz.bus.sensitive.metric.BuiltInProvider;
import org.miaixz.bus.sensitive.metric.CardProvider;
import org.miaixz.bus.sensitive.metric.CitizenIdProvider;
import org.miaixz.bus.sensitive.metric.CnapsProvider;
import org.miaixz.bus.sensitive.metric.DafaultProvider;
import org.miaixz.bus.sensitive.metric.EmailProvider;
import org.miaixz.bus.sensitive.metric.MobileProvider;
import org.miaixz.bus.sensitive.metric.NameProvider;
import org.miaixz.bus.sensitive.metric.NoneProvider;
import org.miaixz.bus.sensitive.metric.PasswordProvider;
import org.miaixz.bus.sensitive.metric.PhoneProvider;
import org.miaixz.bus.sensitive.metric.StrategyProvider;

public final class Registry {
    private static Map<Builder.Type, StrategyProvider> STRATEGY_CACHE = new ConcurrentHashMap<Builder.Type, StrategyProvider>();

    public static void register(Builder.Type name, StrategyProvider object) {
        if (STRATEGY_CACHE.containsKey((Object)name)) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + String.valueOf((Object)name));
        }
        Class<?> clazz = object.getClass();
        if (STRATEGY_CACHE.containsKey(clazz.getSimpleName())) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u7c7b\u578b\u7684\u7ec4\u4ef6\uff1a" + String.valueOf(clazz));
        }
        STRATEGY_CACHE.putIfAbsent(name, object);
    }

    public static StrategyProvider require(Builder.Type name) {
        StrategyProvider sensitiveProvider = STRATEGY_CACHE.get((Object)name);
        if (ObjectKit.isEmpty((Object)sensitiveProvider)) {
            throw new IllegalArgumentException("none sensitiveProvider be found!, type:" + String.valueOf((Object)name));
        }
        return sensitiveProvider;
    }

    public static StrategyProvider require(Class<? extends Annotation> annotationClass) {
        StrategyProvider strategy = STRATEGY_CACHE.get(annotationClass);
        if (ObjectKit.isEmpty((Object)strategy)) {
            throw new InternalException("\u4e0d\u652f\u6301\u7684\u7cfb\u7edf\u5185\u7f6e\u65b9\u6cd5,\u7528\u6237\u8bf7\u52ff\u5728\u81ea\u5b9a\u4e49\u6ce8\u89e3\u4e2d\u4f7f\u7528[BuiltInStrategy]!");
        }
        return strategy;
    }

    public static StrategyProvider require(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Strategy sensitiveStrategy = annotation.annotationType().getAnnotation(Strategy.class);
            if (!ObjectKit.isNotEmpty((Object)sensitiveStrategy)) continue;
            Class<? extends StrategyProvider> clazz = sensitiveStrategy.value();
            StrategyProvider strategy = BuiltInProvider.class.equals(clazz) ? Registry.require(annotation.annotationType()) : (StrategyProvider)ReflectKit.newInstance(clazz, (Object[])new Object[0]);
            return strategy;
        }
        return null;
    }

    public boolean contains(String name) {
        return STRATEGY_CACHE.containsKey(name);
    }

    static {
        Registry.register(Builder.Type.ADDRESS, new AddressProvider());
        Registry.register(Builder.Type.BANK_CARD, new BandCardProvider());
        Registry.register(Builder.Type.CNAPS_CODE, new CnapsProvider());
        Registry.register(Builder.Type.DEFAUL, new DafaultProvider());
        Registry.register(Builder.Type.EMAIL, new EmailProvider());
        Registry.register(Builder.Type.CITIZENID, new CitizenIdProvider());
        Registry.register(Builder.Type.MOBILE, new MobileProvider());
        Registry.register(Builder.Type.NAME, new NameProvider());
        Registry.register(Builder.Type.NONE, new NoneProvider());
        Registry.register(Builder.Type.PASSWORD, new PasswordProvider());
        Registry.register(Builder.Type.PAY_SIGN_NO, new CardProvider());
        Registry.register(Builder.Type.PHONE, new PhoneProvider());
    }
}

