/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.format;

import java.util.Objects;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.setting.Format;
import org.miaixz.bus.setting.format.ElementFormatter;
import org.miaixz.bus.setting.metric.ini.IniComment;
import org.miaixz.bus.setting.metric.ini.IniElement;
import org.miaixz.bus.setting.metric.ini.IniProperty;
import org.miaixz.bus.setting.metric.ini.IniSection;

public class DefaultFormatter
implements Format {
    protected final ElementFormatter<IniComment> commentElementFormatter;
    protected final ElementFormatter<IniSection> sectionElementFormatter;
    protected final ElementFormatter<IniProperty> propertyElementFormatter;
    protected IniSection lastSection;
    private int lineNumber = 0;
    private int effectiveLineNumber = 0;

    public DefaultFormatter(ElementFormatter<IniComment> commentElementFormatter, ElementFormatter<IniSection> sectionElementFormatter, ElementFormatter<IniProperty> propertyElementFormatter) {
        this.commentElementFormatter = commentElementFormatter;
        this.sectionElementFormatter = sectionElementFormatter;
        this.propertyElementFormatter = propertyElementFormatter;
    }

    @Override
    public IniElement formatLine(String raw) {
        IniElement element;
        Objects.requireNonNull(raw);
        ++this.lineNumber;
        String line = raw.trim();
        if (line.length() == 0) {
            return null;
        }
        int preEffectiveLineNumber = this.effectiveLineNumber + 1;
        if (this.commentElementFormatter.check(line)) {
            element = this.commentElementFormatter.format(line, preEffectiveLineNumber);
        } else if (this.sectionElementFormatter.check(line)) {
            IniSection section;
            this.lastSection = section = this.sectionElementFormatter.format(line, preEffectiveLineNumber);
            element = section;
        } else if (this.propertyElementFormatter.check(line)) {
            IniProperty property = this.propertyElementFormatter.format(line, preEffectiveLineNumber);
            if (null == this.lastSection) {
                throw new InternalException("Cannot found section for property line " + this.lineNumber + " : " + line);
            }
            property.setSection(this.lastSection);
            this.lastSection.add(property);
            element = property;
        } else {
            throw new InternalException("No matching element type found for line " + this.lineNumber + " : " + line);
        }
        this.effectiveLineNumber = preEffectiveLineNumber;
        return element;
    }

    @Override
    public synchronized void init() {
        this.lineNumber = 0;
        this.effectiveLineNumber = 0;
        this.lastSection = null;
    }
}

