/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.metric.ini;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringJoiner;
import org.miaixz.bus.setting.metric.ini.IniElement;
import org.miaixz.bus.setting.metric.ini.IniProperty;
import org.miaixz.bus.setting.metric.props.Props;

public class IniSetting
extends ArrayList<IniElement> {
    public IniSetting() {
    }

    public IniSetting(int initialCapacity) {
        super(initialCapacity);
    }

    public IniSetting(Collection<? extends IniElement> c) {
        super(c);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        String newLineSplit = this.getNewLineSplit();
        StringJoiner joiner = new StringJoiner(newLineSplit);
        for (IniElement iniElement : this) {
            joiner.add(null == iniElement ? "" : iniElement.toString());
        }
        return joiner.toString();
    }

    private String getNewLineSplit() {
        return System.getProperty("line.separator", "\n");
    }

    public Props toProperties(String delimiter) {
        Props prop = new Props();
        for (IniElement next : this) {
            if (!next.isProperty()) continue;
            IniProperty inip = (IniProperty)next;
            Object pk = null != delimiter ? inip.getSection().value() + delimiter + inip.key() : inip.key();
            prop.setProperty((String)pk, next.value());
        }
        return prop;
    }

    public Props toProperties() {
        return this.toProperties(".");
    }

    public void write(OutputStream out, Charset charset, boolean withComment) throws IOException {
        for (IniElement element : this) {
            if (!withComment && element.isComment()) continue;
            String text = null == element ? this.getNewLineSplit() : (withComment ? String.valueOf(element) + this.getNewLineSplit() : element.toNoCommentString() + this.getNewLineSplit());
            out.write(text.getBytes(charset));
        }
        out.flush();
    }

    public void write(OutputStream out, boolean withComment) throws IOException {
        this.write(out, org.miaixz.bus.core.lang.Charset.UTF_8, withComment);
    }

    public void write(Writer writer, boolean withComment) throws IOException {
        for (IniElement element : this) {
            if (!withComment && element.isComment()) continue;
            String text = null == element ? this.getNewLineSplit() : (withComment ? String.valueOf(element) + this.getNewLineSplit() : element.toNoCommentString() + this.getNewLineSplit());
            writer.write(text);
        }
        writer.flush();
    }

    public void write(PrintStream print, boolean withComment) {
        for (IniElement element : this) {
            if (!withComment && element.isComment()) continue;
            String text = null == element ? "" : (withComment ? element.toString() : element.toNoCommentString());
            print.println(text);
        }
        print.flush();
    }

    public void write(File file, Charset charset, boolean withComment) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.write(out, charset, withComment);
        }
    }

    public void write(File file, boolean withComment) throws IOException {
        this.write(file, org.miaixz.bus.core.lang.Charset.UTF_8, withComment);
    }

    public void write(Path path, Charset charset, boolean withComment) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            this.write(out, charset, withComment);
        }
    }

    public void write(Path path, boolean withComment) throws IOException {
        this.write(path, org.miaixz.bus.core.lang.Charset.UTF_8, withComment);
    }
}

