/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.metric.toml;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.setting.metric.toml.Toml;

public class TomlReader {
    private final String data;
    private final boolean strictAsciiBareKeys;
    private int pos = 0;
    private int line = 1;

    public TomlReader(String data, boolean strictAsciiBareKeys) {
        this.data = data;
        this.strictAsciiBareKeys = strictAsciiBareKeys;
    }

    public Map<String, Object> read() {
        Map<String, Object> map = this.nextTableContent();
        if (!this.hasNext() && this.pos > 0 && this.data.charAt(this.pos - 1) == '[') {
            throw new InternalException("Invalid table declaration at line " + this.line + ": it never ends");
        }
        while (this.hasNext()) {
            boolean twoBrackets;
            char c = this.nextUseful(true);
            if (c == '[') {
                twoBrackets = true;
                c = this.nextUseful(false);
            } else {
                twoBrackets = false;
            }
            --this.pos;
            ArrayList<String> keyParts = new ArrayList<String>(4);
            boolean insideSquareBrackets = true;
            while (insideSquareBrackets) {
                if (!this.hasNext()) {
                    throw new InternalException("Invalid table declaration at line " + this.line + ": it never ends");
                }
                String name = null;
                char nameFirstChar = this.nextUseful(false);
                switch (nameFirstChar) {
                    case '\"': {
                        char c3;
                        char c2;
                        if (this.pos + 1 < this.data.length()) {
                            c2 = this.data.charAt(this.pos);
                            c3 = this.data.charAt(this.pos + 1);
                            if (c2 == '\"' && c3 == '\"') {
                                this.pos += 2;
                                name = this.nextBasicMultilineString();
                            }
                        }
                        if (name != null) break;
                        name = this.nextBasicString();
                        break;
                    }
                    case '\'': {
                        char c3;
                        char c2;
                        if (this.pos + 1 < this.data.length()) {
                            c2 = this.data.charAt(this.pos);
                            c3 = this.data.charAt(this.pos + 1);
                            if (c2 == '\'' && c3 == '\'') {
                                this.pos += 2;
                                name = this.nextLiteralMultilineString();
                            }
                        }
                        if (name != null) break;
                        name = this.nextLiteralString();
                        break;
                    }
                    default: {
                        --this.pos;
                        name = this.nextBareKey(']', '.').trim();
                        if (this.data.charAt(this.pos) == ']') {
                            if (!name.isEmpty()) {
                                keyParts.add(name);
                            }
                            insideSquareBrackets = false;
                        } else if (name.isEmpty()) {
                            throw new InternalException("Invalid empty data at line " + this.line);
                        }
                        ++this.pos;
                    }
                }
                if (!insideSquareBrackets) continue;
                keyParts.add(name.trim());
            }
            if (keyParts.isEmpty()) {
                throw new InternalException("Invalid empty data at line " + this.line);
            }
            if (twoBrackets && this.next() != ']') {
                throw new InternalException("Missing character ']' at line " + this.line);
            }
            Map<String, Object> value = this.nextTableContent();
            Map<String, Object> valueMap = map;
            for (int i = 0; i < keyParts.size() - 1; ++i) {
                Map childMap;
                String part = (String)keyParts.get(i);
                Object child = valueMap.get(part);
                if (child == null) {
                    childMap = new LinkedHashMap(4);
                    valueMap.put(part, childMap);
                } else if (child instanceof Map) {
                    childMap = (Map)child;
                } else {
                    List list = (List)child;
                    childMap = (Map)list.get(list.size() - 1);
                }
                valueMap = childMap;
            }
            if (twoBrackets) {
                String name = (String)keyParts.get(keyParts.size() - 1);
                ArrayList<Map<String, Object>> tableArray = (ArrayList<Map<String, Object>>)valueMap.get(name);
                if (tableArray == null) {
                    tableArray = new ArrayList<Map<String, Object>>(2);
                    valueMap.put(name, tableArray);
                }
                tableArray.add(value);
                continue;
            }
            valueMap.put((String)keyParts.get(keyParts.size() - 1), value);
        }
        return map;
    }

    private boolean hasNext() {
        return this.pos < this.data.length();
    }

    private char next() {
        return this.data.charAt(this.pos++);
    }

    private char nextUseful(boolean skipComments) {
        char c = ' ';
        while (this.hasNext() && (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '#' && skipComments)) {
            c = this.next();
            if (skipComments && c == '#') {
                int nextLinebreak = this.data.indexOf(10, this.pos);
                if (nextLinebreak == -1) {
                    this.pos = this.data.length();
                    continue;
                }
                this.pos = nextLinebreak + 1;
                ++this.line;
                continue;
            }
            if (c != 10) continue;
            ++this.line;
        }
        return c;
    }

    private char nextUsefulOrLinebreak() {
        char c = ' ';
        while (c == ' ' || c == '\t' || c == '\r') {
            if (!this.hasNext()) {
                return '\n';
            }
            c = this.next();
        }
        if (c == '\n') {
            ++this.line;
        }
        return c;
    }

    private Object nextValue(char firstChar) {
        switch (firstChar) {
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.nextNumberOrDate(firstChar);
            }
            case '\"': {
                if (this.pos + 1 < this.data.length()) {
                    char c2 = this.data.charAt(this.pos);
                    char c3 = this.data.charAt(this.pos + 1);
                    if (c2 == '\"' && c3 == '\"') {
                        this.pos += 2;
                        return this.nextBasicMultilineString();
                    }
                }
                return this.nextBasicString();
            }
            case '\'': {
                if (this.pos + 1 < this.data.length()) {
                    char c2 = this.data.charAt(this.pos);
                    char c3 = this.data.charAt(this.pos + 1);
                    if (c2 == '\'' && c3 == '\'') {
                        this.pos += 2;
                        return this.nextLiteralMultilineString();
                    }
                }
                return this.nextLiteralString();
            }
            case '[': {
                return this.nextArray();
            }
            case '{': {
                return this.nextInlineTable();
            }
            case 't': {
                if (this.pos + 3 > this.data.length() || this.next() != 'r' || this.next() != 'u' || this.next() != 'e') {
                    throw new InternalException("Invalid value at line " + this.line);
                }
                return true;
            }
            case 'f': {
                if (this.pos + 4 > this.data.length() || this.next() != 'a' || this.next() != 'l' || this.next() != 's' || this.next() != 'e') {
                    throw new InternalException("Invalid value at line " + this.line);
                }
                return false;
            }
        }
        throw new InternalException("Invalid character '" + this.toString(firstChar) + "' at line " + this.line);
    }

    private List<Object> nextArray() {
        ArrayList<Object> list;
        block4: {
            char afterEntry;
            list = new ArrayList<Object>();
            do {
                char c;
                if ((c = this.nextUseful(true)) == ']') {
                    ++this.pos;
                } else {
                    Object value = this.nextValue(c);
                    if (!list.isEmpty() && !list.get(0).getClass().isAssignableFrom(value.getClass())) {
                        throw new InternalException("Invalid array at line " + this.line + ": all the values must have the same type");
                    }
                    list.add(value);
                    afterEntry = this.nextUseful(true);
                    if (afterEntry != ']') continue;
                    ++this.pos;
                }
                break block4;
            } while (afterEntry == ',');
            throw new InternalException("Invalid array at line " + this.line + ": expected a comma after each value");
        }
        --this.pos;
        list.trimToSize();
        return list;
    }

    private Map<String, Object> nextInlineTable() {
        char after;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        do {
            char separator;
            char nameFirstChar = this.nextUsefulOrLinebreak();
            String name = null;
            switch (nameFirstChar) {
                case '}': {
                    return map;
                }
                case '\"': {
                    char c3;
                    char c2;
                    if (this.pos + 1 < this.data.length()) {
                        c2 = this.data.charAt(this.pos);
                        c3 = this.data.charAt(this.pos + 1);
                        if (c2 == '\"' && c3 == '\"') {
                            this.pos += 2;
                            name = this.nextBasicMultilineString();
                        }
                    }
                    if (name != null) break;
                    name = this.nextBasicString();
                    break;
                }
                case '\'': {
                    char c3;
                    char c2;
                    if (this.pos + 1 < this.data.length()) {
                        c2 = this.data.charAt(this.pos);
                        c3 = this.data.charAt(this.pos + 1);
                        if (c2 == '\'' && c3 == '\'') {
                            this.pos += 2;
                            name = this.nextLiteralMultilineString();
                        }
                    }
                    if (name != null) break;
                    name = this.nextLiteralString();
                    break;
                }
                default: {
                    --this.pos;
                    name = this.nextBareKey(' ', '\t', '=');
                    if (!name.isEmpty()) break;
                    throw new InternalException("Invalid empty data at line " + this.line);
                }
            }
            if ((separator = this.nextUsefulOrLinebreak()) != '=') {
                throw new InternalException("Invalid character '" + this.toString(separator) + "' at line " + this.line + ": expected '='");
            }
            char valueFirstChar = this.nextUsefulOrLinebreak();
            Object value = this.nextValue(valueFirstChar);
            map.put(name, value);
            after = this.nextUsefulOrLinebreak();
            if (after != '}' && this.hasNext()) continue;
            return map;
        } while (after == ',');
        throw new InternalException("Invalid inline table at line " + this.line + ": missing comma");
    }

    private Map<String, Object> nextTableContent() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while (true) {
            char separator;
            char nameFirstChar = this.nextUseful(true);
            if (!this.hasNext() || nameFirstChar == '[') {
                return map;
            }
            String name = null;
            switch (nameFirstChar) {
                case '\"': {
                    char c3;
                    char c2;
                    if (this.pos + 1 < this.data.length()) {
                        c2 = this.data.charAt(this.pos);
                        c3 = this.data.charAt(this.pos + 1);
                        if (c2 == '\"' && c3 == '\"') {
                            this.pos += 2;
                            name = this.nextBasicMultilineString();
                        }
                    }
                    if (name != null) break;
                    name = this.nextBasicString();
                    break;
                }
                case '\'': {
                    char c3;
                    char c2;
                    if (this.pos + 1 < this.data.length()) {
                        c2 = this.data.charAt(this.pos);
                        c3 = this.data.charAt(this.pos + 1);
                        if (c2 == '\'' && c3 == '\'') {
                            this.pos += 2;
                            name = this.nextLiteralMultilineString();
                        }
                    }
                    if (name != null) break;
                    name = this.nextLiteralString();
                    break;
                }
                default: {
                    --this.pos;
                    name = this.nextBareKey(' ', '\t', '=');
                    if (!name.isEmpty()) break;
                    throw new InternalException("Invalid empty data at line " + this.line);
                }
            }
            if ((separator = this.nextUsefulOrLinebreak()) != '=') {
                throw new InternalException("Invalid character '" + this.toString(separator) + "' at line " + this.line + ": expected '='");
            }
            char valueFirstChar = this.nextUsefulOrLinebreak();
            if (valueFirstChar == '\n') {
                throw new InternalException("Invalid newline before the value at line " + this.line);
            }
            Object value = this.nextValue(valueFirstChar);
            char afterEntry = this.nextUsefulOrLinebreak();
            if (afterEntry == '#') {
                --this.pos;
            } else if (afterEntry != '\n') {
                throw new InternalException("Invalid character '" + this.toString(afterEntry) + "' after the value at line " + this.line);
            }
            if (map.containsKey(name)) {
                throw new InternalException("Duplicate data \"" + name + "\"");
            }
            map.put(name, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object nextNumberOrDate(char first) {
        boolean maybeDouble = true;
        boolean maybeInteger = true;
        boolean maybeDate = true;
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        block9: while (this.hasNext()) {
            char c = this.next();
            switch (c) {
                case ':': 
                case 'T': 
                case 'Z': {
                    maybeDouble = false;
                    maybeInteger = false;
                    break;
                }
                case 'E': 
                case 'e': {
                    maybeDate = false;
                    maybeInteger = false;
                    break;
                }
                case '.': {
                    maybeInteger = false;
                    break;
                }
                case '-': {
                    if (this.pos == 0 || this.data.charAt(this.pos - 1) == 'e' || this.data.charAt(this.pos - 1) == 'E') break;
                    maybeDouble = false;
                    maybeInteger = false;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ']': 
                case '}': {
                    --this.pos;
                    break block9;
                }
            }
            if (c == '_') {
                maybeDate = false;
                continue;
            }
            sb.append(c);
        }
        String valueStr = sb.toString();
        try {
            if (maybeInteger) {
                if (valueStr.length() >= 10) return Long.parseLong(valueStr);
                return Integer.parseInt(valueStr);
            }
            if (maybeDouble) {
                return Double.parseDouble(valueStr);
            }
            if (!maybeDate) throw new InternalException("Invalid value: \"" + valueStr + "\" at line " + this.line);
            return Toml.DATE_FORMATTER.parseBest(valueStr, ZonedDateTime::from, LocalDateTime::from, LocalDate::from);
        }
        catch (Exception ex) {
            throw new InternalException("Invalid value: \"" + valueStr + "\" at line " + this.line, (Throwable)ex);
        }
    }

    private String nextBareKey(char ... allowedEnds) {
        for (int i = this.pos; i < this.data.length(); ++i) {
            char c = this.data.charAt(i);
            for (char allowedEnd : allowedEnds) {
                if (c != allowedEnd) continue;
                String keyName = this.data.substring(this.pos, i);
                this.pos = i;
                return keyName;
            }
            if (this.strictAsciiBareKeys) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-') continue;
                throw new InternalException("Forbidden character '" + this.toString(c) + "' in strict bare-data at line " + this.line);
            }
            if (c > ' ' && c != '#' && c != '=' && c != '.' && c != '[' && c != ']') continue;
            throw new InternalException("Forbidden character '" + this.toString(c) + "' in lenient bare-data at line " + this.line);
        }
        throw new InternalException("Invalid data/value pair at line " + this.line + " end of data reached before the value attached to the data was found");
    }

    private String nextLiteralString() {
        int index = this.data.indexOf(39, this.pos);
        if (index == -1) {
            throw new InternalException("Invalid literal String at line " + this.line + ": it never ends");
        }
        String text = this.data.substring(this.pos, index);
        if (text.indexOf(10) != -1) {
            throw new InternalException("Invalid literal String at line " + this.line + ": newlines are not allowed here");
        }
        this.pos = index + 1;
        return text;
    }

    private String nextLiteralMultilineString() {
        String text;
        int index = this.data.indexOf("'''", this.pos);
        if (index == -1) {
            throw new InternalException("Invalid multiline literal String at line " + this.line + ": it never ends");
        }
        if (this.data.charAt(this.pos) == '\r' && this.data.charAt(this.pos + 1) == '\n') {
            text = this.data.substring(this.pos + 2, index);
            ++this.line;
        } else if (this.data.charAt(this.pos) == '\n') {
            text = this.data.substring(this.pos + 1, index);
            ++this.line;
        } else {
            text = this.data.substring(this.pos, index);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '\n') continue;
            ++this.line;
        }
        this.pos = index + 3;
        return text;
    }

    private String nextBasicString() {
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        while (this.hasNext()) {
            char c = this.next();
            if (c == '\n' || c == '\r') {
                throw new InternalException("Invalid basic String at line " + this.line + ": newlines not allowed");
            }
            if (escape) {
                sb.append(this.unescape(c));
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') {
                return sb.toString();
            }
            sb.append(c);
        }
        throw new InternalException("Invalid basic String at line " + this.line + ": it nerver ends");
    }

    private String nextBasicMultilineString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean escape = false;
        while (this.hasNext()) {
            char c = this.next();
            if (first && (c == '\r' || c == '\n')) {
                if (c == '\r' && this.hasNext() && this.data.charAt(this.pos) == '\n') {
                    ++this.pos;
                } else {
                    ++this.line;
                }
                first = false;
                continue;
            }
            if (escape) {
                if (c == '\r' || c == '\n' || c == ' ' || c == '\t') {
                    if (c == '\r' && this.hasNext() && this.data.charAt(this.pos) == '\n') {
                        ++this.pos;
                    } else if (c == '\n') {
                        ++this.line;
                    }
                    this.nextUseful(false);
                    --this.pos;
                } else {
                    sb.append(this.unescape(c));
                }
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') {
                if (this.pos + 1 >= this.data.length()) break;
                if (this.data.charAt(this.pos) != '\"' || this.data.charAt(this.pos + 1) != '\"') continue;
                this.pos += 2;
                return sb.toString();
            }
            if (c == '\n') {
                ++this.line;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        throw new InternalException("Invalid multiline basic String at line " + this.line + ": it never ends");
    }

    private char unescape(char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case 'u': {
                if (this.data.length() - this.pos < 5) {
                    throw new InternalException("Invalid unicode code point at line " + this.line);
                }
                String unicode = this.data.substring(this.pos, this.pos + 4);
                this.pos += 4;
                try {
                    int hexVal = Integer.parseInt(unicode, 16);
                    return (char)hexVal;
                }
                catch (NumberFormatException ex) {
                    throw new InternalException("Invalid unicode code point at line " + this.line, (Throwable)ex);
                }
            }
            case 'U': {
                if (this.data.length() - this.pos < 9) {
                    throw new InternalException("Invalid unicode code point at line " + this.line);
                }
                String unicode = this.data.substring(this.pos, this.pos + 8);
                this.pos += 8;
                try {
                    int hexVal = Integer.parseInt(unicode, 16);
                    return (char)hexVal;
                }
                catch (NumberFormatException ex) {
                    throw new InternalException("Invalid unicode code point at line " + this.line, (Throwable)ex);
                }
            }
        }
        throw new InternalException("Invalid escape sequence: \"\\" + c + "\" at line " + this.line);
    }

    private String toString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
        }
        return String.valueOf(c);
    }
}

