/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.magic;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import org.miaixz.bus.core.center.map.concurrent.SafeConcurrentHashMap;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.setting.Setting;

public class Profile
implements Serializable {
    public static final String DEFAULT_PROFILE = "default";
    private static final long serialVersionUID = -1L;
    private final Map<String, Setting> settingMap = new SafeConcurrentHashMap();
    private String profile;
    private Charset charset;
    private boolean useVar;

    public Profile() {
        this(DEFAULT_PROFILE);
    }

    public Profile(String profile) {
        this(profile, Setting.DEFAULT_CHARSET, false);
    }

    public Profile(String profile, Charset charset, boolean useVar) {
        this.profile = profile;
        this.charset = charset;
        this.useVar = useVar;
    }

    public Setting getSetting(String name) {
        String nameForProfile = this.fixNameForProfile(name);
        Setting setting = this.settingMap.get(nameForProfile);
        if (null == setting) {
            setting = new Setting(nameForProfile, this.charset, this.useVar);
            this.settingMap.put(nameForProfile, setting);
        }
        return setting;
    }

    public Profile setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public Profile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Profile setUseVar(boolean useVar) {
        this.useVar = useVar;
        return this;
    }

    public Profile clear() {
        this.settingMap.clear();
        return this;
    }

    private String fixNameForProfile(String name) {
        Assert.notBlank((CharSequence)name, (String)"Setting name must be not blank !", (Object[])new Object[0]);
        String actralProfile = StringKit.toStringOrEmpty((Object)this.profile);
        if (!name.contains(".")) {
            return StringKit.format((CharSequence)"{}/{}.setting", (Object[])new Object[]{actralProfile, name});
        }
        return StringKit.format((CharSequence)"{}/{}", (Object[])new Object[]{actralProfile, name});
    }
}

