/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.metric.ini;

import org.miaixz.bus.setting.metric.ini.IniComment;
import org.miaixz.bus.setting.metric.ini.IniElement;

public abstract class AbstractElement
implements IniElement {
    private String value;
    private int lineNumber;
    private String originalValue;
    private IniComment comment;

    AbstractElement(String value, String originalValue, int lineNumber) {
        this.value = value;
        this.lineNumber = lineNumber;
        this.originalValue = originalValue;
        this.comment = null;
    }

    AbstractElement(String value, String originalValue, int lineNumber, IniComment comment) {
        this.value = value;
        this.lineNumber = lineNumber;
        this.originalValue = originalValue;
        this.comment = comment;
    }

    protected static String trim(String value) {
        return value.trim();
    }

    protected abstract String valueChanged(String var1);

    @Override
    public String value() {
        return this.value;
    }

    protected void changeValue(String newValue) {
        this.value = newValue;
    }

    @Override
    public String setValue(String newValue) {
        String old = this.value;
        this.changeValue(newValue);
        this.setOriginalValue(this.valueChanged(newValue));
        return old;
    }

    @Override
    public String toString() {
        return this.toCompleteString();
    }

    @Override
    public String getOriginalValue() {
        return this.originalValue;
    }

    protected void setOriginalValue(String newOriginalValue) {
        this.originalValue = newOriginalValue;
    }

    @Override
    public IniComment getComment() {
        return this.comment;
    }

    @Override
    public void clearComment() {
        this.comment = null;
    }

    @Override
    public String toNoCommentString() {
        return this.originalValue;
    }

    @Override
    public String toCompleteString() {
        return null == this.comment ? this.originalValue : this.originalValue + " " + String.valueOf(this.comment);
    }

    @Override
    public int line() {
        return this.lineNumber;
    }

    @Override
    public int length() {
        return this.value().length();
    }

    @Override
    public char charAt(int index) {
        return this.value().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }
}

