/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.metric.ini;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.miaixz.bus.setting.metric.ini.IniComment;
import org.miaixz.bus.setting.metric.ini.IniCommentCreator;
import org.miaixz.bus.setting.metric.ini.IniElement;
import org.miaixz.bus.setting.metric.ini.IniProperty;
import org.miaixz.bus.setting.metric.ini.IniPropertyCreator;
import org.miaixz.bus.setting.metric.ini.IniSection;
import org.miaixz.bus.setting.metric.ini.IniSectionCreator;
import org.miaixz.bus.setting.metric.ini.IniSetting;

public class INI {
    private List<IniElement> elements;
    private LinkedList<Supplier<IniProperty>> waitForSections = new LinkedList();
    private IniSection lastSection;
    private int line = 1;
    private IniSectionCreator iniSectionCreator = IniSectionCreator.DEFAULT;
    private IniCommentCreator iniCommentCreator = IniCommentCreator.DEFAULT;
    private IniPropertyCreator iniPropertyCreator = IniPropertyCreator.DEFAULT;

    public INI() {
        this.elements = new ArrayList<IniElement>();
    }

    public INI(Supplier<List<IniElement>> listSupplier) {
        this.elements = listSupplier.get();
    }

    public INI sectionCreator(IniSectionCreator iniSectionCreator) {
        Objects.requireNonNull(iniSectionCreator);
        this.iniSectionCreator = iniSectionCreator;
        return this;
    }

    public INI commentCreator(IniCommentCreator iniCommentCreator) {
        Objects.requireNonNull(iniCommentCreator);
        this.iniCommentCreator = iniCommentCreator;
        return this;
    }

    public INI propertyCreator(IniPropertyCreator iniPropertyCreator) {
        Objects.requireNonNull(iniPropertyCreator);
        this.iniPropertyCreator = iniPropertyCreator;
        return this;
    }

    public INI skipLine(int length) {
        for (int i = 0; i < length; ++i) {
            this.elements.add(null);
            ++this.line;
        }
        return this;
    }

    public INI plus(INI otherBuilder) {
        this.elements.addAll(otherBuilder.elements);
        this.line += otherBuilder.line - 1;
        return this;
    }

    public INI plus(List<IniElement> elements) {
        this.elements.addAll(elements);
        this.line += elements.size();
        return this;
    }

    public INI plusSection(String value) {
        IniSection section = this.iniSectionCreator.create(value, this.line++, null);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    public INI plusSection(String value, IniComment comment) {
        IniSection section = this.iniSectionCreator.create(value, this.line++, comment);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    public INI plusSection(String value, String commentValue) {
        int lineNumber = this.line++;
        IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
        IniSection section = this.iniSectionCreator.create(value, lineNumber, comment);
        this.elements.add(section);
        this.lastSection = section;
        this.checkProps();
        return this;
    }

    public INI plusProperty(String key, String value) {
        this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, null));
        return this;
    }

    public INI plusProperty(String key, String value, IniComment comment) {
        this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, comment));
        return this;
    }

    public INI plusProperty(String key, String value, String commentValue) {
        this.checkProps(() -> {
            int lineNumber = this.line++;
            IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
            return this.iniPropertyCreator.create(key, value, lineNumber, comment);
        });
        return this;
    }

    public INI plusProperties(Properties properties) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, null));
        }
        return this;
    }

    public INI plusProperties(Properties properties, IniComment comment) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> this.iniPropertyCreator.create(key, value, this.line++, comment));
        }
        return this;
    }

    public INI plusProperties(Properties properties, String commentValue) {
        Set<String> names = properties.stringPropertyNames();
        for (String key : names) {
            String value = properties.getProperty(key);
            this.checkProps(() -> {
                int lineNumber = this.line++;
                IniComment comment = this.iniCommentCreator.create(commentValue, lineNumber);
                return this.iniPropertyCreator.create(key, value, lineNumber, comment);
            });
        }
        return this;
    }

    public INI plusComment(String value) {
        IniComment comment = this.iniCommentCreator.create(value, this.line++);
        this.elements.add(comment);
        return this;
    }

    public IniSetting build() {
        return new IniSetting((Collection<? extends IniElement>)this.elements);
    }

    private void checkProps() {
        if (null != this.lastSection && !this.waitForSections.isEmpty()) {
            while (!this.waitForSections.isEmpty()) {
                IniProperty property = this.waitForSections.removeLast().get();
                property.setSection(this.lastSection);
                this.lastSection.add(property);
                this.elements.add(property);
            }
        }
    }

    private void checkProps(Supplier<IniProperty> propertySupplier) {
        if (null == this.lastSection) {
            this.waitForSections.addFirst(propertySupplier);
        } else {
            this.checkProps();
            IniProperty property = propertySupplier.get();
            property.setSection(this.lastSection);
            this.lastSection.add(property);
            this.elements.add(property);
        }
    }
}

