/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.miaixz.bus.core.io.LineReader;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.lang.exception.NotFoundException;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.setting.Factory;
import org.miaixz.bus.setting.Format;
import org.miaixz.bus.setting.format.CommentFormatter;
import org.miaixz.bus.setting.format.DefaultFormatter;
import org.miaixz.bus.setting.format.ElementFormatter;
import org.miaixz.bus.setting.format.PropertyFormatter;
import org.miaixz.bus.setting.format.SectionFormatter;
import org.miaixz.bus.setting.magic.GroupedMap;
import org.miaixz.bus.setting.metric.ini.IniComment;
import org.miaixz.bus.setting.metric.ini.IniElement;
import org.miaixz.bus.setting.metric.ini.IniProperty;
import org.miaixz.bus.setting.metric.ini.IniSection;
import org.miaixz.bus.setting.metric.ini.IniSetting;

public class Loader {
    private static char COMMENT_FLAG_PRE = (char)35;
    private char assignFlag = (char)61;
    private Charset charset;
    private boolean isUseVariable;
    private String varRegex = "\\$\\{(.*?)\\}";
    private ValueEditor valueEditor;
    private Factory formatterFactory;
    private Supplier<ElementFormatter<IniComment>> commentElementFormatterSupplier = CommentFormatter::new;
    private Supplier<ElementFormatter<IniSection>> sectionElementFormatterSupplier = SectionFormatter::new;
    private Supplier<ElementFormatter<IniProperty>> propertyElementFormatterSupplier = PropertyFormatter::new;

    public Loader() {
        this.formatterFactory = DefaultFormatter::new;
    }

    public Loader(Factory formatterFactory) {
        this.formatterFactory = formatterFactory;
    }

    public Loader(Charset charset, boolean isUseVariable) {
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public GroupedMap load(Resource resource) throws NotFoundException {
        GroupedMap groupedMap;
        Assert.notNull((Object)resource, (String)"Null setting url define!", (Object[])new Object[0]);
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            groupedMap = this.load(settingStream);
        }
        catch (Exception e) {
            try {
                if (e instanceof NotFoundException) {
                    throw (NotFoundException)e;
                }
                throw new NotFoundException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{settingStream});
        return groupedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GroupedMap load(InputStream inputStream) throws IOException {
        GroupedMap groupedMap = new GroupedMap();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(inputStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StringKit.isBlank((CharSequence)(line = StringKit.trim((CharSequence)line))) || StringKit.startWith((CharSequence)line, (char)COMMENT_FLAG_PRE)) continue;
                if (StringKit.isWrap((CharSequence)line, (char)'[', (char)']')) {
                    group = StringKit.trim((CharSequence)line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = CharsBacker.split((CharSequence)line, (CharSequence)String.valueOf(this.assignFlag), (int)2, (boolean)true, (boolean)false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String key = StringKit.trim((CharSequence)keyValue[0]);
                String value = keyValue[1];
                if (null != this.valueEditor) {
                    value = this.valueEditor.edit(group, key, value);
                }
                if (this.isUseVariable) {
                    value = this.replaceVar(groupedMap, group, value);
                }
                groupedMap.put(group, key, value);
            }
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
            throw throwable;
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
        return groupedMap;
    }

    public void store(GroupedMap groupedMap, String absolutePath) {
        this.store(groupedMap, FileKit.touch((String)absolutePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(GroupedMap groupedMap, File file) {
        Assert.notNull((Object)file, (String)"File to store must be not null !", (Object[])new Object[0]);
        Logger.debug((String)"Store Setting to [{}]...", (Object[])new Object[]{file.getAbsolutePath()});
        PrintWriter writer = null;
        try {
            writer = FileKit.getPrintWriter((File)file, (Charset)this.charset, (boolean)false);
            this.store(groupedMap, writer);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
            throw throwable;
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
    }

    public Loader setVarRegex(String regex) {
        this.varRegex = regex;
        return this;
    }

    public Loader setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
        return this;
    }

    public Loader setValueEditor(ValueEditor valueEditor) {
        this.valueEditor = valueEditor;
        return this;
    }

    private synchronized void store(GroupedMap groupedMap, PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : groupedMap.entrySet()) {
            writer.println(StringKit.format((CharSequence)"{}{}{}", (Object[])new Object[]{Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')}));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(StringKit.format((CharSequence)"{} {} {}", (Object[])new Object[]{entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()}));
            }
        }
    }

    private String replaceVar(GroupedMap groupedMap, String group, String value) {
        Set vars = (Set)PatternKit.findAll((String)this.varRegex, (CharSequence)value, (int)0, new HashSet());
        for (String var : vars) {
            List groupAndKey;
            String key = PatternKit.get((String)this.varRegex, (CharSequence)var, (int)1);
            if (!StringKit.isNotBlank((CharSequence)key)) continue;
            String varValue = groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = CharsBacker.split((CharSequence)key, (CharSequence)".", (int)2, (boolean)true, (boolean)false)).size() > 1) {
                varValue = groupedMap.get((CharSequence)groupAndKey.get(0), (CharSequence)groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = Keys.get((String)key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }

    protected Format getFormatter() {
        return this.formatterFactory.apply(this.commentElementFormatterSupplier.get(), this.sectionElementFormatterSupplier.get(), this.propertyElementFormatterSupplier.get());
    }

    public IniSetting read(InputStream in) throws IOException {
        return this.read(new InputStreamReader(in));
    }

    public IniSetting read(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            IniSetting iniSetting = this.read(reader);
            return iniSetting;
        }
    }

    public IniSetting read(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            IniSetting iniSetting = this.read(reader);
            return iniSetting;
        }
    }

    public IniSetting read(Reader reader) throws IOException {
        BufferedReader bufReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return this.bufferedRead(bufReader);
    }

    protected IniSetting defaultFormat(Reader reader) throws IOException {
        return this.defaultFormat(reader, 16);
    }

    protected IniSetting defaultFormat(Reader reader, int builderCapacity) throws IOException {
        int ch;
        Format format = this.getFormatter();
        ArrayList<IniElement> iniElements = new ArrayList<IniElement>();
        String newLineSplit = System.getProperty("line.separator", "\n");
        StringBuilder line = new StringBuilder(builderCapacity);
        while ((ch = reader.read()) != -1) {
            line.append((char)ch);
            String nowStr = line.toString();
            if (!nowStr.endsWith(newLineSplit)) continue;
            IniElement element = format.formatLine(nowStr);
            if (null != element) {
                iniElements.add(element);
            }
            line.delete(0, line.length());
        }
        if (line.length() > 0) {
            iniElements.add(format.formatLine(line.toString()));
        }
        return new IniSetting((Collection<? extends IniElement>)iniElements);
    }

    private IniSetting bufferedRead(BufferedReader reader) throws IOException {
        return this.defaultFormat(reader);
    }

    public Supplier<ElementFormatter<IniComment>> getCommentElementFormatterSupplier() {
        return this.commentElementFormatterSupplier;
    }

    public void setCommentElementFormatterSupplier(Supplier<ElementFormatter<IniComment>> commentElementFormatterSupplier) {
        this.commentElementFormatterSupplier = commentElementFormatterSupplier;
    }

    public Supplier<ElementFormatter<IniSection>> getSectionElementFormatterSupplier() {
        return this.sectionElementFormatterSupplier;
    }

    public void setSectionElementFormatterSupplier(Supplier<ElementFormatter<IniSection>> sectionElementFormatterSupplier) {
        this.sectionElementFormatterSupplier = sectionElementFormatterSupplier;
    }

    public Supplier<ElementFormatter<IniProperty>> getPropertyElementFormatterSupplier() {
        return this.propertyElementFormatterSupplier;
    }

    public void setPropertyElementFormatterSupplier(Supplier<ElementFormatter<IniProperty>> propertyElementFormatterSupplier) {
        this.propertyElementFormatterSupplier = propertyElementFormatterSupplier;
    }

    @FunctionalInterface
    public static interface ValueEditor {
        public String edit(String var1, String var2, String var3);
    }
}

