/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.metric.props;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.center.function.LambdaX;
import org.miaixz.bus.core.center.function.SupplierX;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.io.watch.SimpleWatcher;
import org.miaixz.bus.core.io.watch.WatchMonitor;
import org.miaixz.bus.core.io.watch.Watcher;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.getter.TypeGetter;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.WatchKit;
import org.miaixz.bus.logger.Logger;

public final class Props
extends Properties
implements TypeGetter<CharSequence> {
    private static final long serialVersionUID = 2852230820065L;
    private static final Map<String, Props> CACHE_PROPS = new ConcurrentHashMap<String, Props>();
    private Resource resource;
    private WatchMonitor watchMonitor;
    private transient Charset charset = org.miaixz.bus.core.lang.Charset.ISO_8859_1;

    public Props() {
    }

    public Props(String path) {
        this(path, null);
    }

    public Props(String path, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceKit.getResource((String)path));
    }

    public Props(File propertiesFile) {
        this(propertiesFile, null);
    }

    public Props(File propertiesFile, Charset charset) {
        Assert.notNull((Object)propertiesFile, (String)"Null properties file!", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceKit.getResource((File)propertiesFile));
    }

    public Props(Resource resource, Charset charset) {
        Assert.notNull((Object)resource, (String)"Null properties URL !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(resource);
    }

    public Props(Properties properties) {
        if (MapKit.isNotEmpty((Map)properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public static Props of() {
        return new Props();
    }

    public static Props of(String resource) {
        return new Props(resource);
    }

    public static Props of(String resource, Charset charset) {
        return new Props(resource, charset);
    }

    public static Props of(Props properties) {
        return new Props(properties);
    }

    public static Props get(String name) {
        return CACHE_PROPS.computeIfAbsent(name, (? super K filePath) -> {
            String extName = FileName.extName((String)filePath);
            if (StringKit.isEmpty((CharSequence)extName)) {
                filePath = (String)filePath + ".setting";
            }
            return new Props((String)filePath);
        });
    }

    public static void parse(Map<String, Object> result, String content) {
        String[] lines;
        for (String line : lines = content.split("\n")) {
            if (StringKit.isBlank((CharSequence)line) || line.startsWith("#") || line.indexOf("=") < 0) continue;
            String key = line.substring(0, line.indexOf("=")).trim();
            String value = line.substring(line.indexOf("=") + 1).trim();
            if (!StringKit.isNotBlank((CharSequence)value)) continue;
            result.put(key, value);
        }
    }

    public static Props getFirstFound(String ... names) {
        for (String name : names) {
            try {
                return Props.get(name);
            }
            catch (InternalException internalException) {
            }
        }
        return null;
    }

    public static Props getProperties() {
        return new Props(System.getProperties());
    }

    public void load(URL url) {
        this.load(ResourceKit.getResource((URL)url));
    }

    public void load(Resource resource) {
        Assert.notNull((Object)resource, (String)"Properties resource must be not null!", (Object[])new Object[0]);
        this.resource = resource;
        ResourceKit.loadTo((Properties)this, (Resource)resource, (Charset)this.charset);
    }

    public void load() {
        this.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull((Object)this.resource, (String)"Properties resource must be not null!", (Object[])new Object[0]);
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.watchMonitor});
            this.watchMonitor = WatchKit.ofModify((URL)this.resource.getUrl(), (Watcher)new SimpleWatcher(){
                private static final long serialVersionUID = 2853080953378L;

                public void onModify(WatchEvent<?> event, WatchKey key) {
                    Props.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.watchMonitor});
            this.watchMonitor = null;
        }
    }

    public Object getObject(CharSequence key, Object defaultValue) {
        Assert.notNull((Object)key, (String)"Key must be not null!", (Object[])new Object[0]);
        return ObjectKit.defaultIfNull((Object)this.getProperty(key.toString()), (Object)defaultValue);
    }

    public <P, T> T get(FunctionX<P, T> func) {
        LambdaX lambdaX = LambdaKit.resolve(func);
        return (T)this.get(lambdaX.getFieldName(), lambdaX.getReturnType());
    }

    public String getAndRemoveString(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public Props getSubProps(String prefix) {
        Props subProps = new Props();
        String finalPrefix = StringKit.addSuffixIfNot((CharSequence)prefix, (CharSequence)".");
        int prefixLength = finalPrefix.length();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String keyStr = key.toString();
            if (StringKit.startWith((CharSequence)keyStr, (CharSequence)finalPrefix)) {
                subProps.set(StringKit.subSuf((CharSequence)keyStr, (int)prefixLength), value);
            }
        }));
        return subProps;
    }

    public Props toProperties() {
        Props properties = new Props();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public <T> T toBean(Class<T> beanClass) {
        return (T)this.toBean((T)beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        Object bean = ReflectKit.newInstanceIfPossible(beanClass);
        return (T)this.toBean(bean, prefix);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, null);
    }

    public <T> T toBean(T bean, String prefix) {
        prefix = StringKit.toStringOrEmpty((Object)StringKit.addSuffixIfNot((CharSequence)prefix, (CharSequence)"."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringKit.startWith((CharSequence)key, (CharSequence)prefix)) continue;
            try {
                BeanKit.setProperty(bean, (String)StringKit.subSuf((CharSequence)key, (int)prefix.length()), (Object)entry.getValue());
            }
            catch (Exception e) {
                Logger.debug((String)"Ignore property: [{}],because of: {}", (Object[])new Object[]{key, e});
            }
        }
        return bean;
    }

    public void set(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public Props setFields(SupplierX<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaKit.getFieldName((Serializable)f), f.get()));
        return this;
    }

    public void store(String absolutePath) throws InternalException {
        BufferedWriter writer = null;
        try {
            writer = FileKit.getWriter((String)absolutePath, (Charset)this.charset, (boolean)false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new InternalException((Throwable)e, "Store properties to [{}] error!", new Object[]{absolutePath});
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileKit.getAbsolutePath((String)path, clazz));
    }
}

