/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.metric.yaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.miaixz.bus.core.center.map.Dictionary;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.yaml.snakeyaml.DumperOptions;

public class Yaml {
    public static Dictionary load(String path) {
        return Yaml.load(path, Dictionary.class);
    }

    public static <T> T load(String path, Class<T> type) {
        return Yaml.load(ResourceKit.getStream((String)path), type);
    }

    public static <T> T load(InputStream in, Class<T> type) {
        return Yaml.load((Reader)IoKit.toBomReader((InputStream)in), type);
    }

    public static Dictionary load(Reader reader) {
        return Yaml.load(reader, Dictionary.class);
    }

    public static <T> T load(Reader reader, Class<T> type) {
        return Yaml.load(reader, type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(Reader reader, Class<T> type, boolean isCloseReader) {
        Object object;
        block4: {
            Assert.notNull((Object)reader, (String)"Reader must be not null !", (Object[])new Object[0]);
            if (null == type) {
                type = Object.class;
            }
            org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml();
            try {
                object = yaml.loadAs(reader, type);
                if (!isCloseReader) break block4;
            }
            catch (Throwable throwable) {
                if (isCloseReader) {
                    IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
                }
                throw throwable;
            }
            IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
        }
        return (T)object;
    }

    public static <T> T parse(String content) {
        return Yaml.parse(null, (Map)new org.yaml.snakeyaml.Yaml().load(content));
    }

    public static <T> T parse(String prefix, Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            String currentKey = prefix == null ? key.toString() : prefix + "." + key.toString();
            Object value = map.get(key);
            if (value instanceof Map) {
                Yaml.parse(currentKey, (Map)value);
                continue;
            }
            result.put(currentKey, value);
        }
        return (T)result;
    }

    public static void dump(Object object, Writer writer) {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml.dump(object, writer, options);
    }

    public static void dump(Object object, Writer writer, DumperOptions dumperOptions) {
        if (null == dumperOptions) {
            dumperOptions = new DumperOptions();
        }
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml(dumperOptions);
        yaml.dump(object, writer);
    }

    public static String replaceRefValue(Properties properties, String value) {
        if (!value.contains("${")) {
            return value;
        }
        String[] segments = value.split("\\$\\{");
        StringBuilder finalValue = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            String seg = StringKit.trimToNull((CharSequence)segments[i]);
            if (StringKit.isBlank((CharSequence)seg)) continue;
            if (seg.contains("}")) {
                String refValue;
                String refKey = seg.substring(0, seg.indexOf("}")).trim();
                String withBraceString = null;
                if (seg.contains("{")) {
                    withBraceString = seg.substring(seg.indexOf("}") + 1);
                }
                String defaultValue = null;
                int defaultValSpliterIndex = refKey.indexOf(":");
                if (defaultValSpliterIndex > 0) {
                    defaultValue = refKey.substring(defaultValSpliterIndex + 1);
                    refKey = refKey.substring(0, defaultValSpliterIndex);
                }
                if (StringKit.isBlank((CharSequence)(refValue = System.getProperty(refKey)))) {
                    refValue = System.getenv(refKey);
                }
                if (StringKit.isBlank((CharSequence)refValue)) {
                    refValue = properties.getProperty(refKey);
                }
                if (StringKit.isBlank((CharSequence)refValue)) {
                    refValue = defaultValue;
                }
                if (StringKit.isBlank((CharSequence)refValue)) {
                    finalValue.append("${" + refKey + "}");
                } else {
                    finalValue.append(refValue);
                }
                if (withBraceString != null) {
                    finalValue.append(withBraceString);
                    continue;
                }
                String[] segments2 = seg.split("\\}");
                if (segments2.length != 2) continue;
                finalValue.append(segments2[1]);
                continue;
            }
            finalValue.append(seg);
        }
        return finalValue.toString();
    }
}

