/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.setting.format;

import org.miaixz.bus.setting.format.AbstractFormatter;
import org.miaixz.bus.setting.format.CommentFormatter;
import org.miaixz.bus.setting.metric.ini.IniProperty;
import org.miaixz.bus.setting.metric.ini.IniPropertyService;

public class PropertyFormatter
extends AbstractFormatter<IniProperty> {
    private char split;

    public PropertyFormatter(CommentFormatter commentElementFormatter) {
        super(commentElementFormatter);
        this.split = (char)61;
    }

    public PropertyFormatter() {
        this.split = (char)61;
    }

    public PropertyFormatter(char split, CommentFormatter commentElementFormatter) {
        super(commentElementFormatter);
        this.split = split;
    }

    public PropertyFormatter(char split) {
        this.split = split;
    }

    @Override
    public boolean check(String value) {
        return value.indexOf(this.split) > 0;
    }

    @Override
    public IniProperty format(String value, int line) {
        String[] split = value.split(String.valueOf('='), 2);
        if (split.length == 1) {
            split = new String[]{split[0], null};
        }
        String propKey = split[0];
        String propValue = split[1];
        return new IniPropertyService(propKey, propValue, value, line);
    }
}

