/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import org.aoju.bus.socket.buffers.BufferFactory;
import org.aoju.bus.socket.buffers.BufferPool;
import org.aoju.bus.socket.channel.SslAsynchronousSocketChannel;
import org.aoju.bus.socket.plugins.AbstractPlugin;
import org.aoju.bus.socket.security.ClientAuth;
import org.aoju.bus.socket.security.SslService;
import org.aoju.bus.socket.security.factory.ClientSSLContextFactory;
import org.aoju.bus.socket.security.factory.SSLContextFactory;
import org.aoju.bus.socket.security.factory.ServerSSLContextFactory;

public final class SslPlugin<T>
extends AbstractPlugin<T> {
    private final SslService sslService;
    private final BufferPool bufferPool;

    public SslPlugin(SSLContextFactory factory, Consumer<SSLEngine> consumer) throws Exception {
        this(factory, consumer, BufferFactory.DISABLED_BUFFER_FACTORY.create());
    }

    public SslPlugin(SSLContextFactory factory, Consumer<SSLEngine> consumer, BufferPool bufferPool) throws Exception {
        this.bufferPool = bufferPool;
        this.sslService = new SslService(factory.create(), consumer);
    }

    public SslPlugin(ClientSSLContextFactory factory) throws Exception {
        this(factory, BufferFactory.DISABLED_BUFFER_FACTORY.create());
    }

    public SslPlugin(ClientSSLContextFactory factory, BufferPool bufferPool) throws Exception {
        this(factory, (SSLEngine sslEngine) -> sslEngine.setUseClientMode(true), bufferPool);
    }

    public SslPlugin(ServerSSLContextFactory factory, ClientAuth clientAuth) throws Exception {
        this(factory, clientAuth, BufferFactory.DISABLED_BUFFER_FACTORY.create());
    }

    public SslPlugin(ServerSSLContextFactory factory, ClientAuth clientAuth, BufferPool bufferPool) throws Exception {
        this((SSLContextFactory)factory, (SSLEngine sslEngine) -> {
            sslEngine.setUseClientMode(false);
            switch (clientAuth) {
                case OPTIONAL: {
                    sslEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + String.valueOf((Object)clientAuth));
                }
            }
        }, bufferPool);
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new SslAsynchronousSocketChannel(channel, this.sslService, this.bufferPool.allocateBufferPage());
    }
}

