/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.socket.AioSession;
import org.miaixz.bus.socket.NetMonitor;
import org.miaixz.bus.socket.ServerConfig;
import org.miaixz.bus.socket.SocketStatus;
import org.miaixz.bus.socket.buffers.BufferPage;
import org.miaixz.bus.socket.buffers.VirtualBuffer;
import org.miaixz.bus.socket.buffers.WriteBuffer;
import org.miaixz.bus.socket.handler.ReadCompletionHandler;
import org.miaixz.bus.socket.handler.WriteCompletionHandler;
import org.miaixz.bus.socket.process.MessageProcessor;

public class TcpAioSession
extends AioSession {
    private final AsynchronousSocketChannel channel;
    private final WriteBuffer byteBuf;
    private final Semaphore semaphore = new Semaphore(1);
    private final ReadCompletionHandler readCompletionHandler;
    private final WriteCompletionHandler writeCompletionHandler;
    private final ServerConfig serverConfig;
    private final Supplier<VirtualBuffer> function;
    boolean eof;
    private VirtualBuffer readBuffer;
    private VirtualBuffer writeBuffer;
    private InputStream inputStream;
    private int modCount = 0;

    TcpAioSession(AsynchronousSocketChannel channel, ServerConfig config, ReadCompletionHandler readCompletionHandler, WriteCompletionHandler writeCompletionHandler, BufferPage bufferPage, Supplier<VirtualBuffer> supplier) {
        this.channel = channel;
        this.readCompletionHandler = readCompletionHandler;
        this.writeCompletionHandler = writeCompletionHandler;
        this.serverConfig = config;
        this.function = supplier;
        Consumer<WriteBuffer> flushConsumer = var -> {
            if (!this.semaphore.tryAcquire()) {
                return;
            }
            this.writeBuffer = var.poll();
            if (this.writeBuffer == null) {
                this.semaphore.release();
            } else {
                this.continueWrite(this.writeBuffer);
            }
        };
        this.byteBuf = new WriteBuffer(bufferPage, flushConsumer, this.serverConfig.getWriteBufferSize(), this.serverConfig.getWriteBufferCapacity());
        config.getProcessor().stateEvent(this, SocketStatus.NEW_SESSION, null);
        this.doRead();
    }

    public void doRead() {
        this.readBuffer = this.function.get();
        this.readBuffer.buffer().flip();
        this.signalRead();
    }

    public void suspendRead() {
        this.readBuffer.clean();
        this.readBuffer = null;
    }

    public void writeCompleted() {
        if (this.writeBuffer == null) {
            this.writeBuffer = this.byteBuf.pollItem();
        } else if (!this.writeBuffer.buffer().hasRemaining()) {
            this.writeBuffer.clean();
            this.writeBuffer = this.byteBuf.pollItem();
        }
        if (this.writeBuffer != null) {
            this.continueWrite(this.writeBuffer);
            return;
        }
        this.semaphore.release();
        if (this.status != 3) {
            this.close();
        } else {
            this.byteBuf.flush();
        }
    }

    @Override
    public WriteBuffer writeBuffer() {
        return this.byteBuf;
    }

    @Override
    public ByteBuffer readBuffer() {
        return this.readBuffer.buffer();
    }

    @Override
    public void awaitRead() {
        ++this.modCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void close(boolean immediate) {
        if (this.status == 1) {
            return;
        }
        this.status = (byte)(immediate ? 1 : 2);
        if (immediate) {
            try {
                this.byteBuf.close();
                this.readBuffer.clean();
                if (this.writeBuffer == null) return;
                this.writeBuffer.clean();
                this.writeBuffer = null;
                return;
            }
            finally {
                IoKit.close((AsynchronousSocketChannel)this.channel);
                this.serverConfig.getProcessor().stateEvent(this, SocketStatus.SESSION_CLOSED, null);
            }
        } else if ((this.writeBuffer == null || !this.writeBuffer.buffer().hasRemaining()) && this.byteBuf.isEmpty()) {
            this.close(true);
            return;
        } else {
            this.serverConfig.getProcessor().stateEvent(this, SocketStatus.SESSION_CLOSING, null);
            this.byteBuf.flush();
        }
    }

    @Override
    public String getSessionID() {
        return "aioSession-" + this.hashCode();
    }

    @Override
    public boolean isInvalid() {
        return this.status != 3;
    }

    public void flipRead(boolean eof) {
        this.eof = eof;
        this.readBuffer.buffer().flip();
    }

    @Override
    public void signalRead() {
        int modCount = this.modCount;
        if (this.status == 1) {
            return;
        }
        ByteBuffer readBuffer = this.readBuffer.buffer();
        MessageProcessor messageProcessor = this.serverConfig.getProcessor();
        while (readBuffer.hasRemaining() && this.status == 3) {
            Object dataEntry;
            try {
                dataEntry = this.serverConfig.getProtocol().decode(readBuffer, this);
            }
            catch (Exception e) {
                messageProcessor.stateEvent(this, SocketStatus.DECODE_EXCEPTION, e);
                throw e;
            }
            if (dataEntry == null) break;
            try {
                messageProcessor.process(this, dataEntry);
                if (modCount == this.modCount) continue;
                return;
            }
            catch (Exception e) {
                messageProcessor.stateEvent(this, SocketStatus.PROCESS_EXCEPTION, e);
            }
        }
        if (this.eof || this.status == 2) {
            this.close(false);
            messageProcessor.stateEvent(this, SocketStatus.INPUT_SHUTDOWN, null);
            return;
        }
        if (this.status == 1) {
            return;
        }
        this.byteBuf.flush();
        readBuffer.compact();
        if (!readBuffer.hasRemaining()) {
            RuntimeException exception = new RuntimeException("readBuffer overflow");
            messageProcessor.stateEvent(this, SocketStatus.DECODE_EXCEPTION, exception);
            throw exception;
        }
        NetMonitor monitor = this.getServerConfig().getMonitor();
        if (monitor != null) {
            monitor.beforeRead(this);
        }
        this.channel.read(readBuffer, 0L, TimeUnit.MILLISECONDS, this, this.readCompletionHandler);
    }

    private int synRead() throws IOException {
        ByteBuffer buffer = this.readBuffer.buffer();
        if (buffer.remaining() > 0) {
            return 0;
        }
        try {
            buffer.clear();
            int size = this.channel.read(buffer).get();
            buffer.flip();
            return size;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void continueWrite(VirtualBuffer writeBuffer) {
        NetMonitor monitor = this.getServerConfig().getMonitor();
        if (monitor != null) {
            monitor.beforeWrite(this);
        }
        this.channel.write(writeBuffer.buffer(), 0L, TimeUnit.MILLISECONDS, this, this.writeCompletionHandler);
    }

    @Override
    public final InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public final InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || null == this.channel) {
            throw new IOException("session is closed");
        }
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return null == this.inputStream ? this.getInputStream(-1) : this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InputStream getInputStream(int length) throws IOException {
        if (null != this.inputStream) {
            throw new IOException("pre inputStream has not closed");
        }
        TcpAioSession tcpAioSession = this;
        synchronized (tcpAioSession) {
            if (null == this.inputStream) {
                this.inputStream = new InnerInputStream(length);
            }
        }
        return this.inputStream;
    }

    private class InnerInputStream
    extends InputStream {
        private int remainLength;

        InnerInputStream(int length) {
            this.remainLength = length >= 0 ? length : -1;
        }

        @Override
        public int read() throws IOException {
            if (this.remainLength == 0) {
                return -1;
            }
            ByteBuffer readBuffer = TcpAioSession.this.readBuffer.buffer();
            if (readBuffer.hasRemaining()) {
                --this.remainLength;
                return readBuffer.get();
            }
            if (TcpAioSession.this.synRead() == -1) {
                this.remainLength = 0;
            }
            return this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (null == b) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.remainLength == 0) {
                return -1;
            }
            if (this.remainLength > 0 && this.remainLength < len) {
                len = this.remainLength;
            }
            ByteBuffer readBuffer = TcpAioSession.this.readBuffer.buffer();
            int size = 0;
            while (len > 0 && TcpAioSession.this.synRead() != -1) {
                int readSize = Math.min(readBuffer.remaining(), len);
                readBuffer.get(b, off + size, readSize);
                size += readSize;
                len -= readSize;
            }
            this.remainLength -= size;
            return size;
        }

        @Override
        public int available() throws IOException {
            if (this.remainLength == 0) {
                return 0;
            }
            if (TcpAioSession.this.synRead() == -1) {
                this.remainLength = 0;
                return this.remainLength;
            }
            ByteBuffer readBuffer = TcpAioSession.this.readBuffer.buffer();
            if (this.remainLength < -1) {
                return readBuffer.remaining();
            }
            return Math.min(this.remainLength, readBuffer.remaining());
        }

        @Override
        public void close() {
            if (TcpAioSession.this.inputStream == this) {
                TcpAioSession.this.inputStream = null;
            }
        }
    }
}

