/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.miaixz.bus.socket.Protocol;
import org.miaixz.bus.socket.ServerConfig;
import org.miaixz.bus.socket.UdpChannel;
import org.miaixz.bus.socket.WorkerRegister;
import org.miaixz.bus.socket.buffers.BufferFactory;
import org.miaixz.bus.socket.buffers.BufferPool;
import org.miaixz.bus.socket.process.MessageProcessor;

public class UdpBootstrap {
    private final ServerConfig config = new ServerConfig();
    private BufferPool bufferPool;
    private BufferPool innerBufferPool = null;
    private WorkerRegister workerRegister;
    private boolean innerWorker = false;

    public <Request> UdpBootstrap(Protocol<Request> protocol, MessageProcessor<Request> messageProcessor, WorkerRegister workerRegister) {
        this(protocol, messageProcessor);
        this.workerRegister = workerRegister;
    }

    public <Request> UdpBootstrap(Protocol<Request> protocol, MessageProcessor<Request> messageProcessor) {
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public UdpChannel open() throws IOException {
        return this.open(0);
    }

    public UdpChannel open(int port) throws IOException {
        return this.open(null, port);
    }

    public UdpChannel open(String host, int port) throws IOException {
        if (this.bufferPool == null) {
            this.innerBufferPool = this.bufferPool = this.config.getBufferFactory().create();
        }
        if (this.workerRegister == null) {
            this.innerWorker = true;
            this.workerRegister = new WorkerRegister(this.bufferPool, this.config.getThreadNum());
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        if (port > 0) {
            InetSocketAddress inetSocketAddress = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
            channel.socket().bind(inetSocketAddress);
        }
        return new UdpChannel(channel, this.workerRegister, this.config, this.bufferPool.allocateBufferPage());
    }

    private synchronized void initWorker() {
        if (this.workerRegister != null) {
            return;
        }
    }

    public void shutdown() {
        if (this.innerWorker) {
            this.workerRegister.shutdown();
        }
        if (this.innerBufferPool != null) {
            this.innerBufferPool.release();
        }
    }

    public final UdpBootstrap setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final UdpBootstrap setThreadNum(int num) {
        this.config.setThreadNum(num);
        return this;
    }

    public final UdpBootstrap setBufferPagePool(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.config.setBufferFactory(BufferFactory.DISABLED_BUFFER_FACTORY);
        return this;
    }

    public final UdpBootstrap setBufferFactory(BufferFactory bufferFactory) {
        this.config.setBufferFactory(bufferFactory);
        this.bufferPool = null;
        return this;
    }
}

