/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.buffers;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.socket.buffers.BufferThread;
import org.miaixz.bus.socket.buffers.VirtualBuffer;

public final class BufferPage {
    private final BufferPage[] poolPages;
    private final ReentrantLock lock = new ReentrantLock();
    private final ByteBuffer buffer;
    private final ConcurrentLinkedQueue<VirtualBuffer> cleanBuffers = new ConcurrentLinkedQueue();
    private final List<VirtualBuffer> availableBuffers;
    private boolean idle = true;

    BufferPage(BufferPage[] poolPages, int size, boolean direct) {
        this.poolPages = Objects.requireNonNull(poolPages);
        this.availableBuffers = new LinkedList<VirtualBuffer>();
        this.buffer = this.allocate0(size, direct);
        this.availableBuffers.add(new VirtualBuffer(this, null, this.buffer.position(), this.buffer.limit()));
    }

    private ByteBuffer allocate0(int size, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    public VirtualBuffer allocate(int size) {
        BufferThread bufferThread;
        Thread thread = Thread.currentThread();
        VirtualBuffer virtualBuffer = thread instanceof BufferThread ? ((bufferThread = (BufferThread)thread).getPageIndex() < this.poolPages.length ? this.poolPages[bufferThread.getPageIndex()].allocate0(size) : this.allocate0(size)) : this.allocate0(size);
        return virtualBuffer == null ? new VirtualBuffer(null, this.allocate0(size, false), 0, 0) : virtualBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualBuffer allocate0(int size) {
        this.idle = false;
        VirtualBuffer cleanBuffer = this.cleanBuffers.poll();
        if (cleanBuffer != null && cleanBuffer.getCapacity() >= size) {
            cleanBuffer.buffer().clear();
            cleanBuffer.buffer(cleanBuffer.buffer());
            return cleanBuffer;
        }
        this.lock.lock();
        try {
            if (cleanBuffer != null) {
                this.clean0(cleanBuffer);
                while ((cleanBuffer = this.cleanBuffers.poll()) != null) {
                    if (cleanBuffer.getCapacity() >= size) {
                        cleanBuffer.buffer().clear();
                        cleanBuffer.buffer(cleanBuffer.buffer());
                        VirtualBuffer virtualBuffer = cleanBuffer;
                        return virtualBuffer;
                    }
                    this.clean0(cleanBuffer);
                }
            }
            int count = this.availableBuffers.size();
            VirtualBuffer bufferChunk = null;
            if (count == 1) {
                bufferChunk = this.fastAllocate(size);
            } else if (count > 1) {
                bufferChunk = this.slowAllocate(size);
            }
            VirtualBuffer virtualBuffer = bufferChunk;
            return virtualBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    private VirtualBuffer fastAllocate(int size) {
        VirtualBuffer bufferChunk;
        VirtualBuffer freeChunk = this.availableBuffers.get(0);
        if (freeChunk == (bufferChunk = this.allocate(size, freeChunk))) {
            this.availableBuffers.clear();
        }
        return bufferChunk;
    }

    private VirtualBuffer slowAllocate(int size) {
        ListIterator<VirtualBuffer> iterator = this.availableBuffers.listIterator(0);
        while (iterator.hasNext()) {
            VirtualBuffer bufferChunk;
            VirtualBuffer freeChunk = (VirtualBuffer)iterator.next();
            if (freeChunk == (bufferChunk = this.allocate(size, freeChunk))) {
                iterator.remove();
            }
            if (null == bufferChunk) continue;
            return bufferChunk;
        }
        return null;
    }

    private VirtualBuffer allocate(int size, VirtualBuffer freeChunk) {
        VirtualBuffer bufferChunk;
        int capacity = freeChunk.getCapacity();
        if (capacity < size) {
            return null;
        }
        if (capacity == size) {
            this.buffer.limit(freeChunk.getParentLimit());
            this.buffer.position(freeChunk.getParentPosition());
            freeChunk.buffer(this.buffer.slice());
            bufferChunk = freeChunk;
        } else {
            this.buffer.limit(freeChunk.getParentPosition() + size);
            this.buffer.position(freeChunk.getParentPosition());
            bufferChunk = new VirtualBuffer(this, this.buffer.slice(), this.buffer.position(), this.buffer.limit());
            freeChunk.setParentPosition(this.buffer.limit());
        }
        if (bufferChunk.buffer().remaining() != size) {
            throw new RuntimeException("allocate " + size + ", buffer:" + String.valueOf(bufferChunk));
        }
        return bufferChunk;
    }

    void clean(VirtualBuffer cleanBuffer) {
        this.cleanBuffers.offer(cleanBuffer);
    }

    void tryClean() {
        if (!this.idle) {
            this.idle = true;
        } else if (!this.cleanBuffers.isEmpty() && this.lock.tryLock()) {
            try {
                VirtualBuffer cleanBuffer;
                while (null != (cleanBuffer = this.cleanBuffers.poll())) {
                    this.clean0(cleanBuffer);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void clean0(VirtualBuffer cleanBuffer) {
        ListIterator<VirtualBuffer> iterator = this.availableBuffers.listIterator(0);
        while (iterator.hasNext()) {
            VirtualBuffer freeBuffer = iterator.next();
            if (freeBuffer.getParentPosition() == cleanBuffer.getParentLimit()) {
                freeBuffer.setParentPosition(cleanBuffer.getParentPosition());
                return;
            }
            if (freeBuffer.getParentLimit() == cleanBuffer.getParentPosition()) {
                freeBuffer.setParentLimit(cleanBuffer.getParentLimit());
                if (iterator.hasNext()) {
                    VirtualBuffer next = iterator.next();
                    if (next.getParentPosition() == freeBuffer.getParentLimit()) {
                        freeBuffer.setParentLimit(next.getParentLimit());
                        iterator.remove();
                    } else if (next.getParentPosition() < freeBuffer.getParentLimit()) {
                        throw new IllegalStateException("");
                    }
                }
                return;
            }
            if (freeBuffer.getParentPosition() <= cleanBuffer.getParentLimit()) continue;
            iterator.previous();
            iterator.add(cleanBuffer);
            return;
        }
        iterator.add(cleanBuffer);
    }

    void release() {
        if (this.buffer.isDirect()) {
            Logger.debug((String)"clean direct buffer", (Object[])new Object[0]);
            this.buffer.clear();
        }
    }

    public String toString() {
        return "BufferPage{availableBuffers=" + String.valueOf(this.availableBuffers) + ", cleanBuffers=" + String.valueOf(this.cleanBuffers) + "}";
    }
}

