/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.buffers;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.socket.buffers.BufferPage;
import org.miaixz.bus.socket.buffers.BufferThread;

public final class BufferPool {
    private static final ScheduledThreadPoolExecutor BUFFER_POOL_CLEAN = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread = new Thread(r, "BufferPoolClean");
        thread.setDaemon(true);
        return thread;
    });
    private final AtomicInteger cursor = new AtomicInteger(0);
    private BufferPage[] bufferPages;
    private boolean enabled = true;
    private final ScheduledFuture<?> future = BUFFER_POOL_CLEAN.scheduleWithFixedDelay(new Runnable(){

        @Override
        public void run() {
            if (BufferPool.this.enabled) {
                for (BufferPage bufferPage : BufferPool.this.bufferPages) {
                    bufferPage.tryClean();
                }
            } else {
                if (BufferPool.this.bufferPages != null) {
                    for (BufferPage page : BufferPool.this.bufferPages) {
                        page.release();
                    }
                    BufferPool.this.bufferPages = null;
                }
                BufferPool.this.future.cancel(false);
            }
        }
    }, 500L, 1000L, TimeUnit.MILLISECONDS);

    public BufferPool(int pageSize, int pageNo, boolean isDirect) {
        this.bufferPages = new BufferPage[pageNo];
        for (int i = 0; i < pageNo; ++i) {
            this.bufferPages[i] = new BufferPage(this.bufferPages, pageSize, isDirect);
        }
        if (pageNo == 0 || pageSize == 0) {
            this.future.cancel(false);
        }
    }

    public Thread newThread(Runnable target, String name) {
        this.assertEnabled();
        BufferThread thread = new BufferThread(target, name);
        thread.setPageIndex((int)(thread.getId() % (long)this.bufferPages.length));
        return thread;
    }

    public BufferPage allocateBufferPage() {
        this.assertEnabled();
        return this.bufferPages[(this.cursor.getAndIncrement() & Integer.MAX_VALUE) % this.bufferPages.length];
    }

    private void assertEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("buffer pool is disable");
        }
    }

    public void release() {
        this.enabled = false;
    }
}

