/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.buffers;

import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import org.miaixz.bus.socket.buffers.BufferPage;

public final class VirtualBuffer {
    private final BufferPage bufferPage;
    private ByteBuffer buffer;
    private Semaphore clean = new Semaphore(1);
    private int parentPosition;
    private int parentLimit;
    private int capacity;

    public VirtualBuffer(BufferPage bufferPage, ByteBuffer buffer, int parentPosition, int parentLimit) {
        this.bufferPage = bufferPage;
        this.buffer = buffer;
        this.parentPosition = parentPosition;
        this.parentLimit = parentLimit;
        this.updateCapacity();
    }

    public static VirtualBuffer wrap(ByteBuffer buffer) {
        return new VirtualBuffer(null, buffer, 0, 0);
    }

    public int getParentPosition() {
        return this.parentPosition;
    }

    public void setParentPosition(int parentPosition) {
        this.parentPosition = parentPosition;
        this.updateCapacity();
    }

    public int getParentLimit() {
        return this.parentLimit;
    }

    public void setParentLimit(int parentLimit) {
        this.parentLimit = parentLimit;
        this.updateCapacity();
    }

    private void updateCapacity() {
        this.capacity = this.parentLimit - this.parentPosition;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public void buffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.clean.release();
    }

    public void clean() {
        if (this.clean.tryAcquire()) {
            if (this.bufferPage != null) {
                this.bufferPage.clean(this);
            }
        } else {
            throw new UnsupportedOperationException("buffer has cleaned");
        }
    }

    public String toString() {
        return "VirtualBuffer{parentPosition=" + this.parentPosition + ", parentLimit=" + this.parentLimit + "}";
    }
}

