/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.buffers;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.miaixz.bus.socket.buffers.BufferPage;
import org.miaixz.bus.socket.buffers.VirtualBuffer;

public class WriteBuffer
extends OutputStream {
    private final VirtualBuffer[] items;
    private final BufferPage bufferPage;
    private final Consumer<WriteBuffer> consumer;
    private final int chunkSize;
    private int takeIndex;
    private int putIndex;
    private int count;
    private VirtualBuffer writeInBuf;
    private boolean closed = false;
    private byte[] cacheByte;

    public WriteBuffer(BufferPage bufferPage, Consumer<WriteBuffer> consumer, int chunkSize, int capacity) {
        this.bufferPage = bufferPage;
        this.consumer = consumer;
        this.items = new VirtualBuffer[capacity];
        this.chunkSize = chunkSize;
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    public void writeShort(short v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[1] = (byte)(v & 0xFF);
        this.write(this.cacheByte, 0, 2);
    }

    public synchronized void writeByte(byte b) {
        if (this.writeInBuf == null) {
            this.writeInBuf = this.bufferPage.allocate(this.chunkSize);
        }
        this.writeInBuf.buffer().put(b);
        this.flushWriteBuffer(false);
    }

    private void flushWriteBuffer(boolean forceFlush) {
        if (!forceFlush && this.writeInBuf.buffer().hasRemaining()) {
            return;
        }
        this.consumer.accept(this);
        if (this.writeInBuf == null || this.writeInBuf.buffer().position() == 0) {
            return;
        }
        this.writeInBuf.buffer().flip();
        VirtualBuffer virtualBuffer = this.writeInBuf;
        this.writeInBuf = null;
        try {
            while (this.count == this.items.length) {
                this.wait();
                if (!this.closed) continue;
                virtualBuffer.clean();
                return;
            }
            this.items[this.putIndex] = virtualBuffer;
            if (++this.putIndex == this.items.length) {
                this.putIndex = 0;
            }
            ++this.count;
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void writeInt(int v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 24 & 0xFF);
        this.cacheByte[1] = (byte)(v >>> 16 & 0xFF);
        this.cacheByte[2] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[3] = (byte)(v & 0xFF);
        this.write(this.cacheByte, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 56 & 0xFFL);
        this.cacheByte[1] = (byte)(v >>> 48 & 0xFFL);
        this.cacheByte[2] = (byte)(v >>> 40 & 0xFFL);
        this.cacheByte[3] = (byte)(v >>> 32 & 0xFFL);
        this.cacheByte[4] = (byte)(v >>> 24 & 0xFFL);
        this.cacheByte[5] = (byte)(v >>> 16 & 0xFFL);
        this.cacheByte[6] = (byte)(v >>> 8 & 0xFFL);
        this.cacheByte[7] = (byte)(v & 0xFFL);
        this.write(this.cacheByte, 0, 8);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.writeInBuf == null) {
            this.writeInBuf = this.bufferPage.allocate(Math.max(this.chunkSize, len));
        }
        ByteBuffer writeBuffer = this.writeInBuf.buffer();
        if (this.closed) {
            this.writeInBuf.clean();
            this.writeInBuf = null;
            throw new IOException("writeBuffer has closed");
        }
        int remaining = writeBuffer.remaining();
        if (remaining > len) {
            writeBuffer.put(b, off, len);
        } else {
            writeBuffer.put(b, off, remaining);
            this.flushWriteBuffer(true);
            if (len > remaining) {
                this.write(b, off + remaining, len - remaining);
            }
        }
    }

    public void write(ByteBuffer buffer) {
        this.write(VirtualBuffer.wrap(buffer));
    }

    public synchronized void write(VirtualBuffer virtualBuffer) {
        if (this.writeInBuf != null && !virtualBuffer.buffer().isDirect() && this.writeInBuf.buffer().remaining() > virtualBuffer.buffer().remaining()) {
            this.writeInBuf.buffer().put(virtualBuffer.buffer());
            virtualBuffer.clean();
        } else {
            if (this.writeInBuf != null) {
                this.flushWriteBuffer(true);
            }
            virtualBuffer.buffer().compact();
            this.writeInBuf = virtualBuffer;
        }
        this.flushWriteBuffer(false);
    }

    private void initCacheBytes() {
        if (this.cacheByte == null) {
            this.cacheByte = new byte[8];
        }
    }

    public void writeAndFlush(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.writeAndFlush(b, 0, b.length);
    }

    public void writeAndFlush(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len);
        this.flush();
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new RuntimeException("OutputStream has closed");
        }
        if (this.count > 0 || this.writeInBuf != null && this.writeInBuf.buffer().position() > 0) {
            this.consumer.accept(this);
        }
    }

    @Override
    public synchronized void close() {
        VirtualBuffer byteBuf;
        if (this.closed) {
            return;
        }
        this.flush();
        this.closed = true;
        if (this.writeInBuf != null) {
            this.writeInBuf.clean();
            this.writeInBuf = null;
        }
        while ((byteBuf = this.poll()) != null) {
            byteBuf.clean();
        }
    }

    public boolean isEmpty() {
        return this.count == 0 && (this.writeInBuf == null || this.writeInBuf.buffer().position() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualBuffer pollItem() {
        if (this.count == 0) {
            return null;
        }
        WriteBuffer writeBuffer = this;
        synchronized (writeBuffer) {
            VirtualBuffer x = this.items[this.takeIndex];
            this.items[this.takeIndex] = null;
            if (++this.takeIndex == this.items.length) {
                this.takeIndex = 0;
            }
            if (this.count-- == this.items.length) {
                this.notifyAll();
            }
            return x;
        }
    }

    public synchronized VirtualBuffer poll() {
        VirtualBuffer item = this.pollItem();
        if (item != null) {
            return item;
        }
        if (this.writeInBuf != null && this.writeInBuf.buffer().position() > 0) {
            this.writeInBuf.buffer().flip();
            VirtualBuffer buffer = this.writeInBuf;
            this.writeInBuf = null;
            return buffer;
        }
        return null;
    }
}

