/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.socket.channel;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.miaixz.bus.socket.channel.EnhanceAsynchronousServerSocketChannel;
import org.miaixz.bus.socket.channel.EnhanceAsynchronousSocketChannel;

public class EnhanceAsynchronousChannelGroup
extends AsynchronousChannelGroup {
    public static final int MAX_INVOKER = 8;
    private final ExecutorService readExecutorService;
    private final ExecutorService writeExecutorService;
    private final Worker[] writeWorkers;
    private final Worker[] readWorkers;
    private final AtomicInteger readIndex = new AtomicInteger(0);
    private final AtomicInteger writeIndex = new AtomicInteger(0);
    private final ScheduledThreadPoolExecutor scheduledExecutor;
    private final ExecutorService acceptExecutorService;
    private final Worker[] acceptWorkers;
    private Worker futureWorker;
    private ExecutorService futureExecutorService;
    private boolean running = true;

    public EnhanceAsynchronousChannelGroup(AsynchronousChannelProvider provider, ExecutorService readExecutorService, int threadNum) throws IOException {
        super(provider);
        int i;
        this.readExecutorService = readExecutorService;
        this.readWorkers = new Worker[threadNum];
        for (int i2 = 0; i2 < threadNum; ++i2) {
            this.readWorkers[i2] = new Worker(Selector.open(), selectionKey -> {
                EnhanceAsynchronousSocketChannel asynchronousSocketChannel = (EnhanceAsynchronousSocketChannel)selectionKey.attachment();
                asynchronousSocketChannel.doRead(true);
            });
            this.readExecutorService.execute(this.readWorkers[i2]);
        }
        boolean writeThreadNum = true;
        boolean acceptThreadNum = true;
        this.writeExecutorService = this.getSingleThreadExecutor("bus-socket:write");
        this.writeWorkers = new Worker[1];
        for (i = 0; i < 1; ++i) {
            this.writeWorkers[i] = new Worker(Selector.open(), selectionKey -> {
                EnhanceAsynchronousSocketChannel asynchronousSocketChannel = (EnhanceAsynchronousSocketChannel)selectionKey.attachment();
                selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                asynchronousSocketChannel.doWrite();
            });
            this.writeExecutorService.execute(this.writeWorkers[i]);
        }
        this.acceptExecutorService = this.getSingleThreadExecutor("bus-socket:connect");
        this.acceptWorkers = new Worker[1];
        for (i = 0; i < 1; ++i) {
            this.acceptWorkers[i] = new Worker(Selector.open(), selectionKey -> {
                if (selectionKey.isAcceptable()) {
                    EnhanceAsynchronousServerSocketChannel serverSocketChannel = (EnhanceAsynchronousServerSocketChannel)selectionKey.attachment();
                    serverSocketChannel.doAccept();
                } else if (selectionKey.isConnectable()) {
                    EnhanceAsynchronousSocketChannel asynchronousSocketChannel = (EnhanceAsynchronousSocketChannel)selectionKey.attachment();
                    asynchronousSocketChannel.doConnect();
                }
            });
            this.acceptExecutorService.execute(this.acceptWorkers[i]);
        }
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "bus-socket:scheduled"));
    }

    public synchronized void registerFuture(Consumer<Selector> register, int opType) throws IOException {
        if (this.futureWorker == null) {
            this.futureExecutorService = this.getSingleThreadExecutor("bus-socket:future");
            this.futureWorker = new Worker(Selector.open(), selectionKey -> {
                EnhanceAsynchronousSocketChannel asynchronousSocketChannel = (EnhanceAsynchronousSocketChannel)selectionKey.attachment();
                switch (opType) {
                    case 1: {
                        this.removeOps((SelectionKey)selectionKey, 1);
                        asynchronousSocketChannel.doRead(true);
                        break;
                    }
                    case 4: {
                        this.removeOps((SelectionKey)selectionKey, 4);
                        asynchronousSocketChannel.doWrite();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unSupport opType: " + opType);
                    }
                }
            });
            this.futureExecutorService.execute(this.futureWorker);
        }
        this.futureWorker.addRegister(register);
    }

    private ThreadPoolExecutor getSingleThreadExecutor(String prefix) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, prefix));
    }

    public void removeOps(SelectionKey selectionKey, int opt) {
        if (selectionKey.isValid() && (selectionKey.interestOps() & opt) != 0) {
            selectionKey.interestOps(selectionKey.interestOps() & ~opt);
        }
    }

    public Worker getReadWorker() {
        return this.readWorkers[(this.readIndex.getAndIncrement() & Integer.MAX_VALUE) % this.readWorkers.length];
    }

    public Worker getWriteWorker() {
        return this.writeWorkers[(this.writeIndex.getAndIncrement() & Integer.MAX_VALUE) % this.writeWorkers.length];
    }

    public Worker getAcceptWorker() {
        return this.acceptWorkers[(this.writeIndex.getAndIncrement() & Integer.MAX_VALUE) % this.acceptWorkers.length];
    }

    public Worker getConnectWorker() {
        return this.acceptWorkers[(this.writeIndex.getAndIncrement() & Integer.MAX_VALUE) % this.acceptWorkers.length];
    }

    public ScheduledThreadPoolExecutor getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Override
    public boolean isShutdown() {
        return this.readExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.readExecutorService.isTerminated();
    }

    @Override
    public void shutdown() {
        this.running = false;
        this.readExecutorService.shutdown();
        this.writeExecutorService.shutdown();
        if (this.acceptExecutorService != null) {
            this.acceptExecutorService.shutdown();
        }
        if (this.futureExecutorService != null) {
            this.futureExecutorService.shutdown();
        }
        this.scheduledExecutor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.running = false;
        this.readExecutorService.shutdownNow();
        this.writeExecutorService.shutdownNow();
        if (this.acceptExecutorService != null) {
            this.acceptExecutorService.shutdownNow();
        }
        if (this.futureExecutorService != null) {
            this.futureExecutorService.shutdownNow();
        }
        this.scheduledExecutor.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.readExecutorService.awaitTermination(timeout, unit);
    }

    public void interestOps(Worker worker, SelectionKey selectionKey, int opt) {
        if ((selectionKey.interestOps() & opt) != 0) {
            return;
        }
        selectionKey.interestOps(selectionKey.interestOps() | opt);
        if (worker.getWorkerThread() != Thread.currentThread()) {
            selectionKey.selector().wakeup();
        }
    }

    public class Worker
    implements Runnable {
        public final Selector selector;
        public final Consumer<SelectionKey> consumer;
        public final ConcurrentLinkedQueue<Consumer<Selector>> consumers = new ConcurrentLinkedQueue();
        public int invoker = 0;
        public Thread workerThread;

        Worker(Selector selector, Consumer<SelectionKey> consumer) {
            this.selector = selector;
            this.consumer = consumer;
        }

        public final void addRegister(Consumer<Selector> register) {
            this.consumers.offer(register);
            this.selector.wakeup();
        }

        public final Thread getWorkerThread() {
            return this.workerThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.workerThread = Thread.currentThread();
            Set<SelectionKey> keySet = this.selector.selectedKeys();
            try {
                while (EnhanceAsynchronousChannelGroup.this.running) {
                    Consumer<Selector> selectorConsumer;
                    while ((selectorConsumer = this.consumers.poll()) != null) {
                        selectorConsumer.accept(this.selector);
                    }
                    this.selector.select();
                    for (SelectionKey key : keySet) {
                        this.invoker = 0;
                        this.consumer.accept(key);
                    }
                    keySet.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.selector.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

